/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.branchratemodel.CountableBranchCategoryProvider;
import dr.evomodel.tree.TreeModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.List;

public class CountableModelMixtureBranchRates
extends AbstractBranchRateModel
implements Loggable {
    private final List<AbstractBranchRateModel> fixedEffectsModels;
    private final TreeModel treeModel;
    private final List<AbstractBranchRateModel> randomEffectsModels;
    private final int categoryCount;
    private final CountableBranchCategoryProvider rateCategories;
    private final boolean modelInLogSpace;

    public CountableModelMixtureBranchRates(CountableBranchCategoryProvider countableBranchCategoryProvider, TreeModel treeModel, List<AbstractBranchRateModel> list, List<AbstractBranchRateModel> list2, boolean bl) {
        super("countableMixtureBranchRates");
        this.treeModel = treeModel;
        this.categoryCount = list.size();
        this.rateCategories = countableBranchCategoryProvider;
        countableBranchCategoryProvider.setCategoryCount(this.categoryCount);
        if (countableBranchCategoryProvider instanceof Model) {
            this.addModel((Model)((Object)countableBranchCategoryProvider));
        }
        this.fixedEffectsModels = list;
        for (AbstractBranchRateModel abstractBranchRateModel : this.fixedEffectsModels) {
            this.addModel(abstractBranchRateModel);
        }
        this.randomEffectsModels = list2;
        if (this.randomEffectsModels != null) {
            for (AbstractBranchRateModel abstractBranchRateModel : this.randomEffectsModels) {
                this.addModel(abstractBranchRateModel);
            }
        }
        this.modelInLogSpace = bl;
    }

    @Override
    public double getLogLikelihood() {
        double d = 0.0;
        for (AbstractBranchRateModel abstractBranchRateModel : this.fixedEffectsModels) {
            d += abstractBranchRateModel.getLogLikelihood();
        }
        if (this.randomEffectsModels != null) {
            for (AbstractBranchRateModel abstractBranchRateModel : this.randomEffectsModels) {
                d += abstractBranchRateModel.getLogLikelihood();
            }
        }
        return d;
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.categoryCount];
        for (int i = 0; i < this.categoryCount; ++i) {
            logColumnArray[i] = new OccupancyColumn(i);
        }
        return logColumnArray;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.rateCategories) {
            this.fireModelChanged();
        } else {
            AbstractBranchRateModel abstractBranchRateModel = this.findModel(model);
            if (abstractBranchRateModel != null) {
                if (object == model) {
                    this.fireModelChanged();
                } else if (object == null) {
                    this.fireModelChanged(null, n);
                } else {
                    this.fireModelChanged();
                }
            } else {
                throw new IllegalArgumentException("Unknown model component!");
            }
        }
    }

    private AbstractBranchRateModel findModel(Model model) {
        int n;
        if (this.randomEffectsModels != null && (n = this.randomEffectsModels.indexOf(model)) != -1) {
            return this.randomEffectsModels.get(n);
        }
        n = this.fixedEffectsModels.indexOf(model);
        if (n != -1) {
            return this.fixedEffectsModels.get(n);
        }
        return null;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        assert (!tree.isRoot(nodeRef)) : "root node doesn't have a rate!";
        int n = this.rateCategories.getBranchCategory(tree, nodeRef);
        AbstractBranchRateModel abstractBranchRateModel = this.fixedEffectsModels.get(n);
        double d = abstractBranchRateModel.getBranchRate(tree, nodeRef);
        if (this.randomEffectsModels != null) {
            for (AbstractBranchRateModel abstractBranchRateModel2 : this.randomEffectsModels) {
                if (this.modelInLogSpace) {
                    d += abstractBranchRateModel2.getBranchRate(tree, nodeRef);
                    continue;
                }
                d *= abstractBranchRateModel2.getBranchRate(tree, nodeRef);
            }
        }
        if (this.modelInLogSpace) {
            d = Math.exp(d);
        }
        return d;
    }

    private class OccupancyColumn
    extends NumberColumn {
        private final int index;

        public OccupancyColumn(int n) {
            super("Occupancy");
            this.index = n;
        }

        @Override
        public double getDoubleValue() {
            int n = 0;
            for (NodeRef nodeRef : CountableModelMixtureBranchRates.this.treeModel.getNodes()) {
                if (nodeRef == CountableModelMixtureBranchRates.this.treeModel.getRoot() || CountableModelMixtureBranchRates.this.rateCategories.getBranchCategory(CountableModelMixtureBranchRates.this.treeModel, nodeRef) != this.index) continue;
                ++n;
            }
            return n;
        }
    }
}

