/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.grid;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.util.ObsCharacteristics;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import jdplus.toolkit.base.api.timeseries.util.TsDataBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public class TsDataBuilders<DATE> {
    private final List<TsDataBuilder<DATE>> builders;

    @NonNull
    public static TsDataBuilders<LocalDateTime> byDateTime(int count, @NonNull ObsGathering gathering, ObsCharacteristics ... characteristics) {
        if (gathering == null) {
            throw new NullPointerException("gathering is marked non-null but is null");
        }
        if (characteristics == null) {
            throw new NullPointerException("characteristics is marked non-null but is null");
        }
        return new TsDataBuilders<LocalDateTime>(IntStream.range(0, count).mapToObj(i -> TsDataBuilder.byDateTime((ObsGathering)gathering, (ObsCharacteristics[])characteristics)).collect(Collectors.toList()));
    }

    public int getCount() {
        return this.builders.size();
    }

    @NonNull
    public TsDataBuilders<DATE> clear() {
        this.builders.forEach(TsDataBuilder::clear);
        return this;
    }

    @NonNull
    public TsDataBuilders<DATE> add(int index, @Nullable DATE date, @Nullable Number value) {
        this.builders.get(index).add(date, value);
        return this;
    }

    @NonNull
    public TsData build(int index) {
        return this.builders.get(index).build();
    }

    @Generated
    private TsDataBuilders(List<TsDataBuilder<DATE>> builders) {
        this.builders = builders;
    }
}

