/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.r;

import com.google.protobuf.InvalidProtocolBufferException;
import jdplus.sa.base.api.EstimationPolicyType;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.r.util.Dictionaries;
import jdplus.x13.base.api.x13.X13Dictionaries;
import jdplus.x13.base.api.x13.X13Spec;
import jdplus.x13.base.core.x13.X13Factory;
import jdplus.x13.base.core.x13.X13Kernel;
import jdplus.x13.base.core.x13.X13Output;
import jdplus.x13.base.core.x13.X13Results;
import jdplus.x13.base.protobuf.Spec;
import jdplus.x13.base.protobuf.SpecProto;
import jdplus.x13.base.protobuf.X13ProtosUtility;
import jdplus.x13.base.protobuf.X13ResultsProto;
import lombok.Generated;

public final class X13 {
    public static byte[] toBuffer(X13Results core) {
        return X13ResultsProto.convert((X13Results)core).toByteArray();
    }

    public static X13Results process(TsData series, String defSpec) {
        X13Spec spec = X13Spec.fromString((String)defSpec);
        X13Kernel kernel = X13Kernel.of((X13Spec)spec, null);
        return kernel.process(series.cleanExtremities(), null);
    }

    public static X13Results process(TsData series, X13Spec spec, ModellingContext context) {
        X13Kernel kernel = X13Kernel.of((X13Spec)spec, (ModellingContext)context);
        return kernel.process(series.cleanExtremities(), null);
    }

    public static X13Spec refreshSpec(X13Spec currentSpec, X13Spec domainSpec, TsDomain domain, String policy) {
        return X13Factory.getInstance().refreshSpec(currentSpec, domainSpec, EstimationPolicyType.valueOf((String)policy), domain);
    }

    public static byte[] toBuffer(X13Spec spec) {
        return SpecProto.convert((X13Spec)spec).toByteArray();
    }

    public static X13Spec specOf(byte[] buffer) {
        try {
            Spec spec = Spec.parseFrom((byte[])buffer);
            return SpecProto.convert((Spec)spec);
        }
        catch (InvalidProtocolBufferException ex) {
            return null;
        }
    }

    public static X13Output fullProcess(TsData series, X13Spec spec, ModellingContext context) {
        X13Kernel tramoseats = X13Kernel.of((X13Spec)spec, (ModellingContext)context);
        X13Results estimation = tramoseats.process(series.cleanExtremities(), null);
        return X13Output.builder().estimationSpec(spec).result(estimation).resultSpec(estimation == null ? null : X13Factory.getInstance().generateSpec(spec, estimation)).build();
    }

    public static X13Output fullProcess(TsData series, String defSpec) {
        X13Spec spec = X13Spec.fromString((String)defSpec);
        return X13.fullProcess(series, spec, null);
    }

    public static byte[] toBuffer(X13Output output) {
        return X13ProtosUtility.convert((X13Output)output).toByteArray();
    }

    public static String[] dictionary() {
        return Dictionaries.entries((Dictionary)X13Dictionaries.X13DICTIONARY);
    }

    public static String[] fullDictionary() {
        return Dictionaries.all((Dictionary)X13Dictionaries.X13DICTIONARY);
    }

    @Generated
    private X13() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

