/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import standalone_spreadsheet.com.github.miachm.sods.OperationNotSupportedException;

public final class Color
implements Cloneable {
    private final int red;
    private final int green;
    private final int blue;

    public Color(int red, int green, int blue) {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Error, parameters out of range (0-255)");
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public Color(String hexform) {
        hexform = hexform.toLowerCase();
        if (hexform.equals("transparent")) {
            throw new OperationNotSupportedException("Transparent color not supported, use a null color object instead");
        }
        if (hexform.length() != 7) {
            throw new IllegalArgumentException("Error in Color, the length of the string is not correct (" + hexform.length() + ")");
        }
        this.red = Integer.valueOf(hexform.substring(1, 3), 16);
        this.green = Integer.valueOf(hexform.substring(3, 5), 16);
        this.blue = Integer.valueOf(hexform.substring(5, 7), 16);
    }

    public int getRed() {
        return this.red;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    private static String fill(String text, int len) {
        for (int diff = text.length() - len; diff < 0; ++diff) {
            text = "0" + text;
        }
        return text;
    }

    public String toString() {
        return "#" + Color.fill(Integer.toHexString(this.red), 2) + Color.fill(Integer.toHexString(this.green), 2) + Color.fill(Integer.toHexString(this.blue), 2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        if (this.red != color.red) {
            return false;
        }
        if (this.blue != color.blue) {
            return false;
        }
        return this.green == color.green;
    }

    public int hashCode() {
        int result = this.red;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

