/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import lombok.Generated;
import lombok.NonNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import spreadsheet.xlsx.XlsxPackage;
import spreadsheet.xlsx.internal.SaxEntryParser;
import standalone_spreadsheet.nbbrd.io.Resource;
import standalone_spreadsheet.nbbrd.io.function.IOSupplier;
import standalone_spreadsheet.nbbrd.io.xml.Sax;
import standalone_spreadsheet.nbbrd.io.zip.Zip;

public final class ZipPackage
implements XlsxPackage {
    @NonNull
    private final Resource.Loader<String> resource;
    private Map<String, String> relationships = null;
    private static final String RELATIONSHIPS_ENTRY_NAME = "xl/_rels/workbook.xml.rels";
    private static final String WORKBOOK_ENTRY_NAME = "xl/workbook.xml";
    private static final String SHARED_STRINGS_ENTRY_NAME = "xl/sharedStrings.xml";
    private static final String STYLES_ENTRY_NAME = "xl/styles.xml";
    public static final XlsxPackage.Factory FACTORY = ZipPackageFactory.INSTANCE;

    @Override
    public InputStream getWorkbook() throws IOException {
        return this.resource.load(WORKBOOK_ENTRY_NAME);
    }

    @Override
    public InputStream getSharedStrings() throws IOException {
        return this.resource.load(SHARED_STRINGS_ENTRY_NAME);
    }

    @Override
    public InputStream getStyles() throws IOException {
        return this.resource.load(STYLES_ENTRY_NAME);
    }

    @Override
    public InputStream getSheet(String relationId) throws IOException {
        return this.resource.load("xl/" + this.getRelationShipPath(relationId));
    }

    @Override
    public void close() throws IOException {
        this.resource.close();
    }

    private String getRelationShipPath(String relationId) throws IOException {
        String result;
        if (this.relationships == null) {
            this.relationships = ZipPackage.parseRelationships(() -> this.resource.load(RELATIONSHIPS_ENTRY_NAME));
        }
        if ((result = this.relationships.get(relationId)) == null) {
            throw new IOException("Cannot find target for '" + relationId + "'");
        }
        return result;
    }

    private static Map<String, String> parseRelationships(IOSupplier<? extends InputStream> byteSource) throws IOException {
        HashMap result = new HashMap();
        return (Map)Sax.Parser.builder().factory(() -> SaxEntryParser.disableNamespaces(Sax.createReader())).contentHandler(new RelationshipsSaxEventHandler(result::put)).after(IOSupplier.of(result)).build().parseStream(byteSource);
    }

    static boolean isUsefulEntryName(String name) {
        switch (name) {
            case "xl/_rels/workbook.xml.rels": 
            case "xl/workbook.xml": 
            case "xl/sharedStrings.xml": 
            case "xl/styles.xml": {
                return true;
            }
        }
        return name.startsWith("xl/worksheets/") && !name.endsWith(".rels");
    }

    @Generated
    public ZipPackage(@NonNull Resource.Loader<String> resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.resource = resource;
    }

    private static final class RelationshipsSaxEventHandler
    extends DefaultHandler {
        private static final String RELATIONSHIP_TAG = "Relationship";
        private static final String ID_ATTRIBUTE = "Id";
        private static final String TARGET_ATTRIBUTE = "Target";
        private final BiConsumer<String, String> visitor;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "Relationship": {
                    this.visitor.accept(attributes.getValue(ID_ATTRIBUTE), attributes.getValue(TARGET_ATTRIBUTE));
                }
            }
        }

        @Generated
        public RelationshipsSaxEventHandler(BiConsumer<String, String> visitor) {
            this.visitor = visitor;
        }
    }

    private static enum ZipPackageFactory implements XlsxPackage.Factory
    {
        INSTANCE;


        @Override
        public XlsxPackage open(InputStream stream) throws IOException {
            return this.open(() -> Zip.loaderCopyOf(stream, ZipPackageFactory::isUsefulEntry));
        }

        @Override
        public XlsxPackage open(Path path) throws IOException {
            Optional<File> file = Resource.getFile(path);
            return file.isPresent() ? this.open(file.get()) : this.open(Files.newInputStream(path, new OpenOption[0]));
        }

        @Override
        public XlsxPackage open(File file) throws IOException {
            try {
                return this.open(() -> Zip.loaderOf(file));
            }
            catch (ZipException ex) {
                if (!ex.getMessage().contains(file.getPath())) {
                    ZipException ex2 = new ZipException(ex.getMessage() + ": " + file.getPath());
                    ex2.addSuppressed(ex);
                    throw ex2;
                }
                throw ex;
            }
        }

        private XlsxPackage open(IOSupplier<Resource.Loader<String>> source) throws IOException {
            return new ZipPackage(source.getWithIO());
        }

        private static boolean isUsefulEntry(ZipEntry entry) {
            return ZipPackage.isUsefulEntryName(entry.getName());
        }
    }
}

