/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.common.util.iterators.IntDomainIterator;
import choco.cp.solver.variables.delta.StackDeltaDomain;
import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.propagation.PropagationEngine;
import gnu.trove.TIntIntHashMap;
import java.util.Random;

public class LinkedIntDomain
extends AbstractIntDomain {
    private static final Random random = new Random(System.currentTimeMillis());
    private final IStateIntVector nextIndex;
    private final IStateIntVector prevIndex;
    private final IStateInt lowerBound;
    private final IStateInt upperBound;
    private final IStateInt size;
    private final int offset;
    private final int[] sortedValues;
    private final TIntIntHashMap val2ind;
    protected IntDomainIterator _iterator;

    public LinkedIntDomain(IntDomainVarImpl v, int a, int b, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        this.offset = a;
        this.lowerBound = environment.makeInt(a);
        this.upperBound = environment.makeInt(b);
        int size = b - a + 1;
        this.sortedValues = new int[size];
        this.val2ind = new TIntIntHashMap();
        this.size = environment.makeInt(size);
        int[] prevIndices = new int[size];
        int[] nextIndices = new int[size];
        for (int i = 0; i < nextIndices.length; ++i) {
            this.sortedValues[i] = a + i;
            this.val2ind.put(a + i, i);
            nextIndices[i] = (i + 1) % size;
            prevIndices[i] = (i - 1 + size) % size;
        }
        this.nextIndex = environment.makeIntVector(nextIndices);
        this.prevIndex = environment.makeIntVector(prevIndices);
        this.deltaDom = new StackDeltaDomain();
    }

    public LinkedIntDomain(IntDomainVarImpl v, int[] sortedValues, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        this.offset = sortedValues[0];
        this.lowerBound = environment.makeInt(sortedValues[0]);
        this.upperBound = environment.makeInt(sortedValues[sortedValues.length - 1]);
        int size = sortedValues.length;
        this.sortedValues = sortedValues;
        this.val2ind = new TIntIntHashMap();
        this.size = environment.makeInt(size);
        int[] prevIndices = new int[size];
        int[] nextIndices = new int[size];
        for (int i = 0; i < sortedValues.length; ++i) {
            this.val2ind.put(sortedValues[i], i);
            nextIndices[i] = (i + 1) % sortedValues.length;
            prevIndices[i] = (i - 1 + sortedValues.length) % sortedValues.length;
        }
        this.nextIndex = environment.makeIntVector(nextIndices);
        this.prevIndex = environment.makeIntVector(prevIndices);
        this.deltaDom = new StackDeltaDomain();
    }

    int indexToValue(int index) {
        return this.sortedValues[index];
    }

    int valueToIndex(int value) {
        if (this.val2ind.containsKey(value)) {
            return this.val2ind.get(value);
        }
        return -1;
    }

    void removeIndex(int indexToRemove) {
        this.nextIndex.set(indexToRemove, -1);
        this.prevIndex.set(indexToRemove, -1);
        this.deltaDom.remove(indexToRemove + this.offset);
        this.size.add(-1);
    }

    @Override
    public int getInf() {
        return this.lowerBound.get();
    }

    @Override
    public int getSup() {
        return this.upperBound.get();
    }

    @Override
    public boolean contains(int x) {
        int xIndex = this.valueToIndex(x);
        return xIndex >= 0 && xIndex < this.nextIndex.size() && this.nextIndex.get(xIndex) != -1;
    }

    @Override
    public int updateInf(int x) {
        int xIndex = this.valueToIndex(x);
        int currentInf = this.valueToIndex(this.lowerBound.get());
        int sup = this.valueToIndex(this.upperBound.get());
        while (currentInf < xIndex && currentInf <= sup) {
            int next = this.nextIndex.get(currentInf);
            this.removeIndex(currentInf);
            currentInf = next;
        }
        this.prevIndex.set(currentInf, sup);
        this.nextIndex.set(sup, currentInf);
        this.lowerBound.set(this.indexToValue(currentInf));
        return this.indexToValue(currentInf);
    }

    @Override
    public int updateSup(int x) {
        int xIndex = this.valueToIndex(x);
        int currentSup = this.valueToIndex(this.upperBound.get());
        int inf = this.valueToIndex(this.lowerBound.get());
        while (currentSup > xIndex) {
            int prev = this.prevIndex.get(currentSup);
            this.removeIndex(currentSup);
            currentSup = prev;
        }
        this.prevIndex.set(inf, currentSup);
        this.nextIndex.set(currentSup, inf);
        this.upperBound.set(this.indexToValue(currentSup));
        return this.indexToValue(currentSup);
    }

    @Override
    public void restrict(int x) {
        int xIndex = this.valueToIndex(x);
        int currentInf = this.valueToIndex(this.lowerBound.get());
        int currentSup = this.valueToIndex(this.upperBound.get());
        while (currentInf < xIndex) {
            int next = this.nextIndex.get(currentInf);
            this.removeIndex(currentInf);
            currentInf = next;
        }
        while (currentSup > xIndex) {
            int prev = this.prevIndex.get(currentSup);
            this.removeIndex(currentSup);
            currentSup = prev;
        }
        this.prevIndex.set(xIndex, xIndex);
        this.nextIndex.set(xIndex, xIndex);
        this.lowerBound.set(x);
        this.upperBound.set(x);
    }

    @Override
    public boolean remove(int x) {
        if (!this.contains(x)) {
            return false;
        }
        int xIndex = this.valueToIndex(x);
        int next = this.nextIndex.get(xIndex);
        int prev = this.prevIndex.get(xIndex);
        if (x == this.lowerBound.get()) {
            this.lowerBound.set(this.indexToValue(next));
        }
        if (x == this.upperBound.get()) {
            this.upperBound.set(this.indexToValue(prev));
        }
        this.removeIndex(xIndex);
        this.prevIndex.set(next, prev);
        this.nextIndex.set(prev, next);
        return true;
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this._iterator == null) {
            this._iterator = new IntDomainIterator();
        } else if (!this._iterator.reusable()) {
            this._iterator = new IntDomainIterator();
        }
        this._iterator.init(this);
        return this._iterator;
    }

    @Override
    public int getNextValue(int x) {
        int inf = this.lowerBound.get();
        if (x < inf) {
            return inf;
        }
        if (!this.hasNextValue(x)) {
            return Integer.MAX_VALUE;
        }
        int xIndex = this.valueToIndex(x);
        if (this.nextIndex.get(xIndex) != -1) {
            return this.indexToValue(this.nextIndex.get(xIndex));
        }
        ++xIndex;
        while (this.nextIndex.get(xIndex) == -1) {
            ++xIndex;
        }
        return this.indexToValue(xIndex);
    }

    @Override
    public int getPrevValue(int x) {
        int sup = this.upperBound.get();
        if (x > sup) {
            return sup;
        }
        if (!this.hasPrevValue(x)) {
            return Integer.MIN_VALUE;
        }
        int xIndex = this.valueToIndex(x);
        if (this.prevIndex.get(xIndex) != -1) {
            return this.indexToValue(this.prevIndex.get(xIndex));
        }
        --xIndex;
        while (this.prevIndex.get(xIndex) == -1) {
            --xIndex;
        }
        return this.indexToValue(xIndex);
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.upperBound.get();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.lowerBound.get();
    }

    @Override
    public int getRandomValue() {
        int size = this.getSize();
        if (size == 1) {
            return this.getInf();
        }
        int rand = random.nextInt(size);
        int val = this.getInf();
        for (int o = 0; o < rand; ++o) {
            val = this.getNextValue(val);
        }
        return val;
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return this.offset == 0 && this.nextIndex.size() == 2;
    }

    @Override
    public String toString() {
        return "{" + this.getInf() + "..." + this.getSup() + '}';
    }

    @Override
    public String pretty() {
        StringBuilder buf = new StringBuilder("{");
        int maxDisplay = 15;
        int count = 0;
        DisposableIntIterator it = this.getIterator();
        while (it.hasNext() && count < maxDisplay) {
            int val = it.next();
            if (++count > 1) {
                buf.append(", ");
            }
            buf.append(val);
        }
        it.dispose();
        if (this.getSize() > maxDisplay) {
            buf.append("..., ");
            buf.append(this.getSup());
        }
        buf.append('}');
        return buf.toString();
    }
}

