/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class OrderedSparseArray {
    int[][] values;
    int[] nbVals;
    int[][] infos;
    int[] indices;
    boolean[] dirs;
    int[] defaults;
    int[] previous;
    int n;
    boolean type;

    public OrderedSparseArray(int n) {
        this(n, false);
    }

    public OrderedSparseArray(int n, boolean type) {
        this.n = n;
        this.type = type;
        this.values = new int[n][];
        this.nbVals = new int[n];
        this.infos = new int[n][];
        this.indices = new int[n];
        this.dirs = new boolean[n];
        this.defaults = new int[n];
        this.previous = new int[n];
    }

    public void allocate(IntDomainVar[] vars, int def) {
        for (int i = 0; i < this.n; ++i) {
            this.values[i] = new int[vars[i].getDomainSize()];
            this.nbVals[i] = vars[i].getDomainSize();
            DisposableIntIterator it = vars[i].getDomain().getIterator();
            int j = 0;
            while (it.hasNext()) {
                this.values[i][j] = it.next();
                ++j;
            }
            it.dispose();
            this.infos[i] = new int[vars[i].getDomainSize()];
            for (j = 0; j < this.nbVals[i]; ++j) {
                this.infos[i][j] = def;
            }
            this.defaults[i] = def;
        }
    }

    public void scanInit(int i, boolean dir) {
        this.dirs[i] = dir;
        this.previous[i] = this.defaults[i];
        this.indices[i] = dir ? -1 : this.nbVals[i];
    }

    public int get(int i, int v) {
        if (this.dirs[i]) {
            while (this.indices[i] == -1 || this.indices[i] <= this.nbVals[i] - 1 && v > this.values[i][this.indices[i]]) {
                if (this.type && this.indices[i] >= 0) {
                    this.previous[i] = this.infos[i][this.indices[i]];
                }
                int n = i;
                this.indices[n] = this.indices[n] + 1;
            }
        } else {
            while (this.indices[i] == this.nbVals[i] || this.indices[i] >= 0 && v < this.values[i][this.indices[i]]) {
                if (this.type && this.indices[i] < this.nbVals[i]) {
                    this.previous[i] = this.infos[i][this.indices[i]];
                }
                int n = i;
                this.indices[n] = this.indices[n] - 1;
            }
        }
        if (this.dirs[i] && (this.indices[i] > this.nbVals[i] - 1 || v < this.values[i][this.indices[i]]) || !this.dirs[i] && (this.indices[i] < 0 || v > this.values[i][this.indices[i]])) {
            if (!this.type) {
                this.previous[i] = this.defaults[i];
                return this.defaults[i];
            }
            return this.previous[i];
        }
        this.previous[i] = this.infos[i][this.indices[i]];
        return this.infos[i][this.indices[i]];
    }

    public void set(int i, int v, int info) {
        if (this.dirs[i]) {
            if (this.indices[i] == -1 || this.values[i][this.indices[i]] < v) {
                if (this.type && this.indices[i] >= 0) {
                    this.previous[i] = this.infos[i][this.indices[i]];
                }
                int n = i;
                this.indices[n] = this.indices[n] + 1;
                this.values[i][this.indices[i]] = v;
            }
        } else if (this.indices[i] == this.nbVals[i] || this.values[i][this.indices[i]] > v) {
            if (this.type && this.indices[i] < this.nbVals[i]) {
                this.previous[i] = this.infos[i][this.indices[i]];
            }
            int n = i;
            this.indices[n] = this.indices[n] - 1;
            this.values[i][this.indices[i]] = v;
        }
        this.infos[i][this.indices[i]] = info;
        this.previous[i] = info;
    }

    public String printer(String name) {
        StringBuilder s = new StringBuilder();
        s.append("name | coords | value | info\n");
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                s.append(name).append(" | [").append(i).append("][").append(j).append("] |   ").append(this.values[i][j]).append("   | ").append(this.infos[i][j]).append('\n');
            }
        }
        return s.toString();
    }
}

