/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.FacetPanel;
import org.rosuda.deducer.plots.ParamFacet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Facet
implements ElementModel {
    private String name;
    public ParamFacet param;
    public String data;
    public String facetType;

    public static Facet makeFacet(String string) {
        Facet facet = new Facet();
        facet.setName("facet_" + string);
        facet.facetType = string;
        ParamFacet paramFacet = new ParamFacet();
        paramFacet.facetType = string;
        facet.param = paramFacet;
        return facet;
    }

    @Override
    public Object clone() {
        Facet facet = new Facet();
        facet.setName(this.name);
        facet.data = this.data;
        facet.param = (ParamFacet)this.param.clone();
        facet.facetType = this.facetType;
        return facet;
    }

    @Override
    public String checkValid() {
        return null;
    }

    @Override
    public String getCall() {
        String[] stringArray = this.param.getParamCalls();
        if (stringArray.length == 0) {
            return null;
        }
        String string = "facet_" + this.param.facetType + "(";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
        }
        string = string + ")";
        return string;
    }

    @Override
    public String getType() {
        return "facet";
    }

    @Override
    public ElementView getView() {
        FacetPanel facetPanel = new FacetPanel();
        facetPanel.setModel(this);
        return facetPanel;
    }

    @Override
    public Vector getParams() {
        Vector<ParamFacet> vector = new Vector<ParamFacet>();
        vector.add(this.param);
        return vector;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("ElementModel");
            element.setAttribute("className", "org.rosuda.deducer.plots.Facet");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.data != null) {
                element.setAttribute("data", this.data);
            }
            if (this.facetType != null) {
                element.setAttribute("facetType", this.facetType);
            }
            Element element2 = this.param.toXML();
            element2 = (Element)document.importNode(element2, true);
            element.appendChild(element2);
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.Facet")) {
            System.out.println("Error Facet: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.data = element.hasAttribute("data") ? element.getAttribute("data") : null;
        this.facetType = element.hasAttribute("facetType") ? element.getAttribute("facetType") : null;
        this.param = new ParamFacet();
        Element element2 = (Element)element.getElementsByTagName("*").item(0);
        this.param.setFromXML(element2);
    }

    @Override
    public String getData() {
        return this.data;
    }
}

