/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.FileIt;
import blbutil.Filter;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import vcf.BitSetGT;
import vcf.Marker;
import vcf.MarkerContainer;
import vcf.VcfEmission;
import vcf.VcfHeader;
import vcf.VcfRecord;

public class VcfIt<E extends MarkerContainer>
implements SampleFileIt<E> {
    private static final float DEFAULT_MAX_LR = Float.MAX_VALUE;
    private final VcfHeader vcfHeader;
    private final FileIt<String> it;
    private final Function<String, E> mapper;
    private final Filter<Marker> markerFilter;
    private final Thread fileReaderThread;
    private volatile boolean stopFileReadingThread = false;
    private final BlockingQueue<String[]> stringBuffers;
    private final Deque<E> emBuffer;
    public static final int DEFAULT_BUFFER_SIZE = 1000;
    public static final BiFunction<VcfHeader, String, VcfRecord> toGTGLRec = (vcfHeader, string) -> VcfRecord.fromGTGL(vcfHeader, string, Float.MAX_VALUE);
    public static final BiFunction<VcfHeader, String, VcfRecord> toGLRec = (vcfHeader, string) -> VcfRecord.fromGL(vcfHeader, string, Float.MAX_VALUE);
    public static final BiFunction<VcfHeader, String, VcfEmission> toBitSetGT = (vcfHeader, string) -> new BitSetGT((VcfHeader)vcfHeader, (String)string);

    public static <R extends VcfEmission> VcfIt<R> create(FileIt<String> fileIt, BiFunction<VcfHeader, String, R> biFunction) {
        return VcfIt.create(fileIt, Filter.acceptAllFilter(), biFunction);
    }

    public static <R extends VcfEmission> VcfIt<R> create(FileIt<String> fileIt, Filter<String> filter, BiFunction<VcfHeader, String, R> biFunction) {
        return VcfIt.create(fileIt, filter, Filter.acceptAllFilter(), biFunction);
    }

    public static <R extends VcfEmission> VcfIt<R> create(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, BiFunction<VcfHeader, String, R> biFunction) {
        return VcfIt.create(fileIt, filter, filter2, biFunction, 1000);
    }

    public static <R extends VcfEmission> VcfIt<R> create(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, BiFunction<VcfHeader, String, R> biFunction, int n) {
        VcfIt<R> vcfIt = new VcfIt<R>(fileIt, filter, filter2, biFunction, n);
        super.start();
        return vcfIt;
    }

    private VcfIt(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, BiFunction<VcfHeader, String, E> biFunction, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (filter2 == null) {
            filter2 = Filter.acceptAllFilter();
        }
        this.vcfHeader = new VcfHeader(fileIt, filter);
        this.it = fileIt;
        this.mapper = string -> (MarkerContainer)biFunction.apply(this.vcfHeader, (String)string);
        this.markerFilter = filter2;
        this.stringBuffers = new ArrayBlockingQueue<String[]>(1);
        this.emBuffer = new ArrayDeque(n);
        this.fileReaderThread = this.fileReadingThread();
    }

    private void start() {
        this.fileReaderThread.setDaemon(true);
        this.fileReaderThread.start();
        this.fillEmissionBuffer();
        if (this.emBuffer.isEmpty()) {
            this.noRecordFoundError(this.it);
        }
    }

    private void noRecordFoundError(FileIt<String> fileIt) {
        if (!fileIt.hasNext()) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("No VCF records found (data source: ");
            stringBuilder.append(fileIt.file() == null ? "stdin" : fileIt.file());
            stringBuilder.append(")");
            stringBuilder.append(Const.nl);
            stringBuilder.append("Check that the chromosome identifiers are the same in each input VCF");
            stringBuilder.append(Const.nl);
            stringBuilder.append("file and in the 'chrom=' command line argument (if 'chrom=' is used).");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    private Thread fileReadingThread() {
        Runnable runnable = () -> {
            String string = VcfIt.readLine(this.it);
            int n = VcfIt.stringBufferSize(string);
            while (string != null && !this.stopFileReadingThread) {
                String string2 = VcfIt.chromFieldPlusTab(string);
                String[] stringArray = new String[n];
                int n2 = 0;
                while (string != null && n2 < n && string.startsWith(string2)) {
                    stringArray[n2++] = string;
                    string = VcfIt.readLine(this.it);
                }
                if (n2 < n) {
                    stringArray = Arrays.copyOf(stringArray, n2);
                }
                VcfIt.putInBlockingQueue(this.stringBuffers, stringArray);
            }
            if (!this.stopFileReadingThread) {
                VcfIt.putInBlockingQueue(this.stringBuffers, new String[0]);
            }
        };
        return new Thread(runnable);
    }

    private static int stringBufferSize(String string) {
        long l;
        if (string == null) {
            return 0;
        }
        long l2 = 2 * string.length();
        Runtime runtime = Runtime.getRuntime();
        long l3 = runtime.maxMemory();
        if (l3 == Long.MAX_VALUE) {
            l3 = 0L;
        }
        if ((l = l3 / (100L * l2)) > 1000L) {
            l = 1000L;
        }
        if (l < 50L) {
            l = 50L;
        }
        return (int)l;
    }

    private static <E> void putInBlockingQueue(BlockingQueue<E> blockingQueue, E e) {
        try {
            blockingQueue.put(e);
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("Error: InterruptedException", interruptedException);
        }
    }

    private static <E> E takeFromBlockingQueue(BlockingQueue<E> blockingQueue) {
        try {
            return blockingQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("Error: InterruptedException", interruptedException);
            assert (false);
            return null;
        }
    }

    private static String chromFieldPlusTab(String string) {
        int n = string.indexOf(9);
        if (n == -1) {
            String string2 = Const.nl + "ERROR: Missing tab delimiter in VCV Record:" + Const.nl + string + Const.nl + "Exiting Program";
            Utilities.exit(string2);
        }
        return string.substring(0, n + 1);
    }

    private void fillEmissionBuffer() {
        assert (this.emBuffer.isEmpty());
        int n = -1;
        while (n != 0 && this.emBuffer.size() < 1000) {
            String[] stringArray = VcfIt.takeFromBlockingQueue(this.stringBuffers);
            n = stringArray.length;
            if (stringArray.length > 0) {
                List list = ((Stream)Arrays.stream(stringArray).parallel()).map(this.mapper).filter(markerContainer -> this.markerFilter.accept(markerContainer.marker())).collect(Collectors.toList());
                this.emBuffer.addAll(list);
                continue;
            }
            VcfIt.putInBlockingQueue(this.stringBuffers, stringArray);
        }
    }

    private static String readLine(FileIt<String> fileIt) {
        if (!fileIt.hasNext()) {
            return null;
        }
        String string = (String)fileIt.next();
        while (string.trim().isEmpty() && fileIt.hasNext()) {
            string = (String)fileIt.next();
        }
        return string;
    }

    @Override
    public void close() {
        this.stopFileReadingThread = true;
        this.stringBuffers.poll();
        try {
            this.fileReaderThread.join();
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("Error: InterruptedException", interruptedException);
        }
        this.it.close();
        this.emBuffer.clear();
    }

    @Override
    public boolean hasNext() {
        return !this.emBuffer.isEmpty();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        MarkerContainer markerContainer = (MarkerContainer)this.emBuffer.removeFirst();
        if (this.emBuffer.isEmpty()) {
            this.fillEmissionBuffer();
        }
        return (E)markerContainer;
    }

    @Override
    public void remove() {
        String string = "remove() is not supported by VcfIterator";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public File file() {
        return this.it.file();
    }

    @Override
    public Samples samples() {
        return this.vcfHeader.samples();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(" : ");
        stringBuilder.append(this.it.file() == null ? "stdin" : this.it.file().toString());
        return stringBuilder.toString();
    }
}

