/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class NaiveBayesSimple
extends Classifier
implements TechnicalInformationHandler {
    static final long serialVersionUID = -1478242251770381214L;
    protected double[][][] m_Counts;
    protected double[][] m_Means;
    protected double[][] m_Devs;
    protected double[] m_Priors;
    protected Instances m_Instances;
    protected static double NORM_CONST = Math.sqrt(Math.PI * 2);

    public String globalInfo() {
        return "Class for building and using a simple Naive Bayes classifier.Numeric attributes are modelled by a normal distribution.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Richard Duda and Peter Hart");
        result.setValue(TechnicalInformation.Field.YEAR, "1973");
        result.setValue(TechnicalInformation.Field.TITLE, "Pattern Classification and Scene Analysis");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Wiley");
        result.setValue(TechnicalInformation.Field.ADDRESS, "New York");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        double sum;
        Attribute attribute;
        Attribute attribute2;
        int attIndex = 0;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Instances = new Instances(instances, 0);
        this.m_Counts = new double[instances.numClasses()][instances.numAttributes() - 1][0];
        this.m_Means = new double[instances.numClasses()][instances.numAttributes() - 1];
        this.m_Devs = new double[instances.numClasses()][instances.numAttributes() - 1];
        this.m_Priors = new double[instances.numClasses()];
        Enumeration enu = instances.enumerateAttributes();
        while (enu.hasMoreElements()) {
            int j;
            Attribute attribute3 = (Attribute)enu.nextElement();
            if (attribute3.isNominal()) {
                j = 0;
                while (j < instances.numClasses()) {
                    this.m_Counts[j][attIndex] = new double[attribute3.numValues()];
                    ++j;
                }
            } else {
                j = 0;
                while (j < instances.numClasses()) {
                    this.m_Counts[j][attIndex] = new double[1];
                    ++j;
                }
            }
            ++attIndex;
        }
        Enumeration enumInsts = instances.enumerateInstances();
        while (enumInsts.hasMoreElements()) {
            Instance instance = (Instance)enumInsts.nextElement();
            if (instance.classIsMissing()) continue;
            Enumeration enumAtts = instances.enumerateAttributes();
            attIndex = 0;
            while (enumAtts.hasMoreElements()) {
                attribute2 = (Attribute)enumAtts.nextElement();
                if (!instance.isMissing(attribute2)) {
                    if (attribute2.isNominal()) {
                        double[] dArray = this.m_Counts[(int)instance.classValue()][attIndex];
                        int n = (int)instance.value(attribute2);
                        dArray[n] = dArray[n] + 1.0;
                    } else {
                        double[] dArray = this.m_Means[(int)instance.classValue()];
                        int n = attIndex;
                        dArray[n] = dArray[n] + instance.value(attribute2);
                        double[] dArray2 = this.m_Counts[(int)instance.classValue()][attIndex];
                        dArray2[0] = dArray2[0] + 1.0;
                    }
                }
                ++attIndex;
            }
            int n = (int)instance.classValue();
            this.m_Priors[n] = this.m_Priors[n] + 1.0;
        }
        Enumeration enumAtts = instances.enumerateAttributes();
        attIndex = 0;
        while (enumAtts.hasMoreElements()) {
            attribute = (Attribute)enumAtts.nextElement();
            if (attribute.isNumeric()) {
                int j = 0;
                while (j < instances.numClasses()) {
                    if (this.m_Counts[j][attIndex][0] < 2.0) {
                        throw new Exception("attribute " + attribute.name() + ": less than two values for class " + instances.classAttribute().value(j));
                    }
                    double[] dArray = this.m_Means[j];
                    int n = attIndex;
                    dArray[n] = dArray[n] / this.m_Counts[j][attIndex][0];
                    ++j;
                }
            }
            ++attIndex;
        }
        enumInsts = instances.enumerateInstances();
        while (enumInsts.hasMoreElements()) {
            Instance instance = (Instance)enumInsts.nextElement();
            if (instance.classIsMissing()) continue;
            enumAtts = instances.enumerateAttributes();
            attIndex = 0;
            while (enumAtts.hasMoreElements()) {
                attribute2 = (Attribute)enumAtts.nextElement();
                if (!instance.isMissing(attribute2) && attribute2.isNumeric()) {
                    double[] dArray = this.m_Devs[(int)instance.classValue()];
                    int n = attIndex;
                    dArray[n] = dArray[n] + (this.m_Means[(int)instance.classValue()][attIndex] - instance.value(attribute2)) * (this.m_Means[(int)instance.classValue()][attIndex] - instance.value(attribute2));
                }
                ++attIndex;
            }
        }
        enumAtts = instances.enumerateAttributes();
        attIndex = 0;
        while (enumAtts.hasMoreElements()) {
            attribute = (Attribute)enumAtts.nextElement();
            if (attribute.isNumeric()) {
                int j = 0;
                while (j < instances.numClasses()) {
                    if (this.m_Devs[j][attIndex] <= 0.0) {
                        throw new Exception("attribute " + attribute.name() + ": standard deviation is 0 for class " + instances.classAttribute().value(j));
                    }
                    double[] dArray = this.m_Devs[j];
                    int n = attIndex;
                    dArray[n] = dArray[n] / (this.m_Counts[j][attIndex][0] - 1.0);
                    this.m_Devs[j][attIndex] = Math.sqrt(this.m_Devs[j][attIndex]);
                    ++j;
                }
            }
            ++attIndex;
        }
        enumAtts = instances.enumerateAttributes();
        attIndex = 0;
        while (enumAtts.hasMoreElements()) {
            attribute = (Attribute)enumAtts.nextElement();
            if (attribute.isNominal()) {
                int j = 0;
                while (j < instances.numClasses()) {
                    sum = Utils.sum(this.m_Counts[j][attIndex]);
                    int i = 0;
                    while (i < attribute.numValues()) {
                        this.m_Counts[j][attIndex][i] = (this.m_Counts[j][attIndex][i] + 1.0) / (sum + (double)attribute.numValues());
                        ++i;
                    }
                    ++j;
                }
            }
            ++attIndex;
        }
        sum = Utils.sum(this.m_Priors);
        int j = 0;
        while (j < instances.numClasses()) {
            this.m_Priors[j] = (this.m_Priors[j] + 1.0) / (sum + (double)instances.numClasses());
            ++j;
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] probs = new double[instance.numClasses()];
        int j = 0;
        while (j < instance.numClasses()) {
            probs[j] = 1.0;
            Enumeration enumAtts = instance.enumerateAttributes();
            int attIndex = 0;
            while (enumAtts.hasMoreElements()) {
                Attribute attribute = (Attribute)enumAtts.nextElement();
                if (!instance.isMissing(attribute)) {
                    if (attribute.isNominal()) {
                        int n = j;
                        probs[n] = probs[n] * this.m_Counts[j][attIndex][(int)instance.value(attribute)];
                    } else {
                        int n = j;
                        probs[n] = probs[n] * this.normalDens(instance.value(attribute), this.m_Means[j][attIndex], this.m_Devs[j][attIndex]);
                    }
                }
                ++attIndex;
            }
            int n = j;
            probs[n] = probs[n] * this.m_Priors[j];
            ++j;
        }
        Utils.normalize(probs);
        return probs;
    }

    public String toString() {
        if (this.m_Instances == null) {
            return "Naive Bayes (simple): No model built yet.";
        }
        try {
            StringBuffer text = new StringBuffer("Naive Bayes (simple)");
            int i = 0;
            while (i < this.m_Instances.numClasses()) {
                text.append("\n\nClass " + this.m_Instances.classAttribute().value(i) + ": P(C) = " + Utils.doubleToString(this.m_Priors[i], 10, 8) + "\n\n");
                Enumeration enumAtts = this.m_Instances.enumerateAttributes();
                int attIndex = 0;
                while (enumAtts.hasMoreElements()) {
                    Attribute attribute = (Attribute)enumAtts.nextElement();
                    text.append("Attribute " + attribute.name() + "\n");
                    if (attribute.isNominal()) {
                        int j = 0;
                        while (j < attribute.numValues()) {
                            text.append(String.valueOf(attribute.value(j)) + "\t");
                            ++j;
                        }
                        text.append("\n");
                        j = 0;
                        while (j < attribute.numValues()) {
                            text.append(String.valueOf(Utils.doubleToString(this.m_Counts[i][attIndex][j], 10, 8)) + "\t");
                            ++j;
                        }
                    } else {
                        text.append("Mean: " + Utils.doubleToString(this.m_Means[i][attIndex], 10, 8) + "\t");
                        text.append("Standard Deviation: " + Utils.doubleToString(this.m_Devs[i][attIndex], 10, 8));
                    }
                    text.append("\n\n");
                    ++attIndex;
                }
                ++i;
            }
            return text.toString();
        }
        catch (Exception e) {
            return "Can't print Naive Bayes classifier!";
        }
    }

    protected double normalDens(double x, double mean, double stdDev) {
        double diff = x - mean;
        return 1.0 / (NORM_CONST * stdDev) * Math.exp(-(diff * diff / (2.0 * stdDev * stdDev)));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5516 $");
    }

    public static void main(String[] argv) {
        NaiveBayesSimple.runClassifier(new NaiveBayesSimple(), argv);
    }
}

