% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\title{Use renv in a project}
\usage{
init(
  project = NULL,
  ...,
  profile = NULL,
  settings = NULL,
  bare = FALSE,
  force = FALSE,
  repos = NULL,
  bioconductor = NULL,
  load = TRUE,
  restart = interactive()
)
}
\arguments{
\item{project}{The project directory. When \code{NULL} (the default), the current
working directory will be used. The \R working directory will be
changed to match the requested project directory.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{profile}{The profile to be activated. See
\code{vignette("profiles", package = "renv")} for more information.
When \code{NULL} (the default), the profile is not changed. Use
\code{profile = "default"} to revert to the default \code{renv} profile.}

\item{settings}{A list of \link{settings} to be used with the newly-initialized
project.}

\item{bare}{Boolean; initialize the project with an empty project library,
without attempting to discover and install \R package dependencies?}

\item{force}{Boolean; force initialization? By default, renv will refuse
to initialize the home directory as a project, to defend against accidental
misusages of \code{init()}.}

\item{repos}{The \R repositories to be used in this project.
See \strong{Repositories} for more details.}

\item{bioconductor}{The version of Bioconductor to be used with this project.
Setting this may be appropriate if renv is unable to determine that your
project depends on a package normally available from Bioconductor. Set this
to \code{TRUE} to use the default version of Bioconductor recommended by the
BiocManager package.}

\item{load}{Boolean; should the project be loaded after it is initialized?}

\item{restart}{Boolean; attempt to restart the \R session after initializing
the project? A session restart will be attempted if the \code{"restart"} \R
option is set by the frontend hosting \R.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Call \code{renv::init()} to start using renv in the current project. This will:
\enumerate{
\item Set up project infrastructure (as described in \code{\link[=scaffold]{scaffold()}}) including
the project library and the \code{.Rprofile} that ensures renv will be
used in all future sessions,
\item Discover the packages that are currently being used in your project
(via \code{\link[=dependencies]{dependencies()}}), and install them into the project library
(as described in \code{\link[=hydrate]{hydrate()}}),
\item Create a lockfile that records the state of the project library so it
can be restored by others (as described in \code{\link[=snapshot]{snapshot()}}),
\item Restart R (if running inside RStudio).
}

If you call \code{renv::init()} with a project that is already using renv, it will
attempt to do the right thing: it will restore the project library if it's
missing, or otherwise ask you what to do.
}
\section{Repositories}{
If the default \R repositories have not already been set, renv will use
the \href{https://packagemanager.posit.co/}{Posit Public Package Manager} CRAN
mirror for package installation. The primary benefit to using this mirror is
that it can provide pre-built binaries for \R packages on a variety of
commonly-used Linux distributions. This behavior can be configured or
disabled if desired -- see the options in \code{\link[=config]{config()}} for more details.
}

\examples{

\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
