/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;

public class HybridizationFingerprinter
extends Fingerprinter
implements IFingerprinter {
    public HybridizationFingerprinter() {
        this(1024, 7);
    }

    public HybridizationFingerprinter(int size) {
        this(size, 7);
    }

    public HybridizationFingerprinter(int size, int searchDepth) {
        super(size, searchDepth);
    }

    @Override
    protected String getBondSymbol(IBond bond) {
        String bondSymbol = "";
        if (bond.getOrder() == IBond.Order.SINGLE) {
            bondSymbol = this.isSP2Bond(bond) ? ":" : "-";
        } else if (bond.getOrder() == IBond.Order.DOUBLE) {
            bondSymbol = this.isSP2Bond(bond) ? ":" : "=";
        } else if (bond.getOrder() == IBond.Order.TRIPLE) {
            bondSymbol = "#";
        } else if (bond.getOrder() == IBond.Order.QUADRUPLE) {
            bondSymbol = "*";
        }
        return bondSymbol;
    }

    private boolean isSP2Bond(IBond bond) {
        return bond.getAtomCount() == 2 && bond.getBegin().getHybridization() == IAtomType.Hybridization.SP2 && bond.getEnd().getHybridization() == IAtomType.Hybridization.SP2;
    }
}

