/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.Message;

public class CMLLog
implements CMLConstants {
    List<Message> messageList = new ArrayList<Message>();

    public void add(Severity severity, String s) {
        this.messageList.add(new Message(severity, s));
    }

    public void add(String s) {
        this.messageList.add(new Message(s));
    }

    public void add(Throwable t, String s) {
        this.messageList.add(new Message(t, s));
    }

    public void add(File file, String s) {
        this.messageList.add(new Message(file, s));
    }

    public void write(Writer w) throws IOException {
        for (Message m : this.messageList) {
            if (m.t != null) {
                w.write(m.t.toString() + ": ");
            }
            w.write(m.s + "\n");
        }
    }

    public void writeXML(Writer w) throws IOException {
        w.write("<log>\n");
        for (Message m : this.messageList) {
            m.writeXML(w);
        }
        w.write("</log>\n");
    }

    public static enum Severity {
        WARNING,
        ERROR,
        INFO;

    }
}

