/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class FragmentComplexityDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"fragC"};

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#NilaComplexity", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 0) {
            throw new CDKException("FragmentComplexityDescriptor expects no parameter");
        }
    }

    public Object[] getParameters() {
        return new Object[0];
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtomContainer container) {
        int a = 0;
        double h = 0.0;
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (container.getAtom(i).getAtomicNumber() != 1) {
                ++a;
            }
            if (container.getAtom(i).getAtomicNumber() == 1 || container.getAtom(i).getAtomicNumber() == 6) continue;
            h += 1.0;
        }
        int b = container.getBondCount() + AtomContainerManipulator.getImplicitHydrogenCount((IAtomContainer)container);
        double c = (double)Math.abs(b * b - a * a + a) + h / 100.0;
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(c), this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    public String[] getParameterNames() {
        return null;
    }

    public Object getParameterType(String name) {
        return null;
    }
}

