## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, fig.align = "center")

## ---- eval = FALSE------------------------------------------------------------
#  library(postpack)
#  data(cjs)

## ---- echo = FALSE------------------------------------------------------------
library(postpack)
load("../data/cjs.rda")

## -----------------------------------------------------------------------------
post_summ(cjs, params = "B", digits = 3)

## ---- fig.width = 4, fig.height = 4-------------------------------------------
diag_plots(cjs, params = "sig")

## -----------------------------------------------------------------------------
match_params(cjs, "2")

## -----------------------------------------------------------------------------
match_params(cjs, "[2]")

## -----------------------------------------------------------------------------
match_params(cjs, "[:alnum:]", auto_escape = FALSE)

## -----------------------------------------------------------------------------
match_params(cjs, "[:alnum:]\\[", auto_escape = FALSE)

## -----------------------------------------------------------------------------
match_params(cjs, "b.[2]")

## -----------------------------------------------------------------------------
post_summ(cjs, "b.[2]", digits = 3)

## -----------------------------------------------------------------------------
match_params(cjs, "^B")

## -----------------------------------------------------------------------------
match_params(cjs, "0$")

## -----------------------------------------------------------------------------
match_params(cjs, "^s.+0$")

