/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.structure.APartiallyStoredCstrList;
import choco.kernel.memory.structure.Couple;
import choco.kernel.memory.structure.PartiallyStoredIntVector;
import choco.kernel.memory.structure.iterators.PSCLEIterator;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;

public final class PartiallyStoredIntCstrList<C extends AbstractSConstraint>
extends APartiallyStoredCstrList<C> {
    private final PartiallyStoredIntVector[] events;
    private final int[] eventTypes;
    private final int[] idxEventTypes;
    private PSCLEIterator<C> _iterator;

    public PartiallyStoredIntCstrList(IEnvironment env, int ... eventTypes) {
        super(env);
        int size = eventTypes.length;
        this.events = new PartiallyStoredIntVector[size];
        this.eventTypes = eventTypes;
        this.idxEventTypes = new int[eventTypes[size - 1] + 1];
        for (int i = 0; i < size; ++i) {
            this.events[i] = env.makePartiallyStoredIntVector();
            this.idxEventTypes[eventTypes[i]] = i;
        }
    }

    @Override
    public int addConstraint(SConstraint c, int varIdx, boolean dynamicAddition) {
        int constraintIdx = super.addConstraint(c, varIdx, dynamicAddition);
        AbstractSConstraint ic = (AbstractSConstraint)c;
        int mask = ic.getFilteredEventMask(varIdx);
        for (int evt : this.eventTypes) {
            if ((mask & evt) == 0) continue;
            this.addEvent(dynamicAddition, this.idxEventTypes[evt], constraintIdx);
        }
        return constraintIdx;
    }

    private void addEvent(boolean dynamicAddition, int indice, int constraintIdx) {
        if (dynamicAddition) {
            this.events[indice].add(constraintIdx);
        } else {
            this.events[indice].staticAdd(constraintIdx);
        }
    }

    @Override
    public int eraseConstraint(SConstraint c) {
        int idx = super.eraseConstraint(c);
        int mask = ((AbstractIntSConstraint)c).getFilteredEventMask(this.indices.get(idx));
        for (int evt : this.eventTypes) {
            if ((mask & evt) == 0) continue;
            this.events[this.idxEventTypes[evt]].remove(idx);
        }
        return idx;
    }

    public PartiallyStoredIntVector[] getEventsVector() {
        return this.events;
    }

    public DisposableIterator<Couple<C>> getActiveConstraint(int event, C cstrCause) {
        if (this._iterator == null) {
            this._iterator = new PSCLEIterator();
        } else if (!this._iterator.reusable()) {
            assert (false);
            this._iterator = new PSCLEIterator();
        }
        this._iterator.init(cstrCause, this.events[this.idxEventTypes[event]], this.elements, this.indices);
        return this._iterator;
    }
}

