# checkpoint 1.0.2

* Output objects from pkgdepends are now saved as rds files instead of json. This is because pkgdepends has the format of some objects to be environments, rather than data frames or lists. This fixes the `object of type environment is not subsettable` error.

# checkpoint 1.0.1

* Maintainer change (Folashade Daniel; fdaniel@microsoft.com).

# checkpoint 1.0.0

This is a **major refactoring/rewrite** of checkpoint, aimed at solving many long-standing issues.

- Switch to [pkgdepends](https://github.com/r-lib/pkgdepends) for the backend, replacing custom-written code that calls `install.packages` and the like. This brings the following benefits:
  - Caching of downloaded packages.
  - Allow installing packages which are in use, without having to unload them first.
  - Comprehensive reporting of all aspects of the install process: dependency resolution, creating an install plan, downloading packages, and actual installation.
  - Reliable detection of installation outcomes (no more having to screen-scrape the R terminal!)
- New functions `create_checkpoint` and `use_checkpoint`, reflecting the two main objectives of the package. The `checkpoint` function calls out to these, based on whether the checkpoint directory exists.
  - A side-effect of this is that calling `checkpoint` in your home directory should result in checkpointing very many packages only once.
- New functions `uncheckpoint` (which is the reverse of `use_checkpoint`), `delete_checkpoint` and `delete_all_checkpoints` to manage checkpointing. They replace `checkpointRemove`, `checkpointArchives` and `unCheckpoint`.
- Function `getValidSnapshots` renamed to `list_mran_snapshots` to clarify that it lists the snapshots on the MRAN server. Similarly, `setSnapshot` renamed to `use_mran_snapshot` for consistency with other function names.
- Function `scanForPackages` renamed to `scan_project_files` to match grammatical pattern of other function names; now automatically includes rmarkdown (not knitr) in the list of dependencies if Rmarkdown-based files are found.
- Experimental support for a `checkpoint.yml` manifest file, to specify packages to include or exclude.
   - Allows including packages from Bioconductor or GitHub in the checkpoint; it's recommended to specify a version number, tag or commit hash to ensure you always get the same version of a package.
- Consistent use of snake_case for all object names and function arguments.
- Remove obsolete code to handle lack of HTTPS support in ancient versions of R. (Note that the MRAN site now requires HTTPS.)
- Other bug fixes and general tidying.
- Maintainer change (James Rowland-Jones; jrj@microsoft.com).

# checkpoint 0.4.10

* Maintainer change (Michelle Wallig; Michelle.Wallig@microsoft.com).

# checkpoint 0.4.9

* Make vignettes static to avoid CRAN check issues.

# checkpoint 0.4.8

* Added a `use.lock` argument to `checkpoint`. When this is `FALSE`, packages are installed without the use of locks (via the `--no-lock` argument to `R CMD INSTALL`). The default is `TRUE`, which is needed to pass checks on R-devel; set this to `FALSE` to replicate the previous behaviour of `checkpoint`.
* Fix build failures with the main checkpoint vignette on R-devel.
* Restored Andrie de Vries and Microsoft to Authors@R in the `DESCRIPTION` file.

# checkpoint 0.4.7

* Fixes for bugs uncovered by R CMD check.
* `unCheckpoint` now automatically restores library paths to their pre-checkpoint state. This fixes the bug where library paths specified by means other than the `R_LIBS_USER` environment variable, eg via code in `.Rprofile`, were not restored. The `new` argument is no longer used, and a warning is printed if it is supplied.
* Skip all tests on CRAN, to avoid issues when MRAN is down.
* Handle an empty local MRAN gracefully (#253).


For package updates in previous releases of checkpoint, please see the releases page at https://github.com/RevolutionAnalytics/checkpoint/releases