/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.Serializable;
import keel.Algorithms.Decision_Trees.M5.M5;
import keel.Algorithms.Decision_Trees.M5.M5Instance;
import keel.Algorithms.Decision_Trees.M5.M5Instances;
import keel.Algorithms.Decision_Trees.M5.Results;

public final class Function
implements Serializable {
    int[] terms;
    double[] coeffs;

    public Function() {
        this.terms = new int[1];
        this.terms[0] = 0;
        this.coeffs = new double[1];
        this.coeffs[0] = 0.0;
    }

    public Function(M5Instances inst) {
        int count = 0;
        this.terms = new int[inst.numAttributes()];
        for (int i = 0; i < inst.numAttributes() - 1; ++i) {
            if (i == inst.classIndex()) continue;
            this.terms[++count] = i;
        }
        this.terms[0] = count;
        this.coeffs = new double[count + 1];
    }

    public Function(int attr) {
        this.terms = new int[2];
        this.terms[0] = 1;
        this.terms[1] = attr;
        this.coeffs = new double[2];
        this.coeffs[0] = 0.0;
        this.coeffs[1] = 0.0;
    }

    public final Function copy() {
        Function fcopy = new Function();
        fcopy.terms = Function.iVectorCopy(this.terms, this.terms[0] + 1);
        fcopy.coeffs = Function.dVectorCopy(this.coeffs, this.terms[0] + 1);
        return fcopy;
    }

    public static final double[] dVectorCopy(double[] a, int n) {
        double[] b = new double[n];
        for (int i = 0; i < n; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public static final int[] iVectorCopy(int[] a, int n) {
        int[] b = new int[n];
        for (int i = 0; i < n; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public final String toString(M5Instances inst, int startPoint) throws Exception {
        int count;
        int precision = 3;
        StringBuffer text = new StringBuffer();
        int count1 = count = startPoint + inst.classAttribute().name().length() + 3;
        String string = M5.doubleToStringG(this.coeffs[0], 1, precision);
        count = this.coeffs[0] >= 0.0 ? (count += string.length()) : (count += 1 + string.length());
        text.append(inst.classAttribute().name() + " = " + string);
        for (int i = 1; i <= this.terms[0]; ++i) {
            string = M5.doubleToStringG(Math.abs(this.coeffs[i]), 1, precision);
            if ((count += 3 + string.length() + inst.attribute(this.terms[i]).name().length()) > 80) {
                text.append("\n");
                for (int j = 1; j <= count1 - 1; ++j) {
                    text.append(" ");
                }
                count = count1 - 1 + 3 + string.length() + inst.attribute(this.terms[i]).name().length();
            }
            if (this.coeffs[i] >= 0.0) {
                text.append(" + ");
            } else {
                text.append(" - ");
            }
            text.append(string + inst.attribute(this.terms[i]).name());
        }
        return text.toString();
    }

    public static final Function combine(Function f1, Function f2) {
        Function f = new Function();
        f.terms = Function.iVectorCombine(f1.terms, f2.terms);
        f.coeffs = new double[f.terms[0] + 1];
        return f;
    }

    public static final int[] iVectorCombine(int[] list1, int[] list2) {
        int k;
        int[] list = new int[list1[0] + list2[0] + 1];
        int count = 0;
        int i = 1;
        int j = 1;
        while (i <= list1[0] && j <= list2[0]) {
            if (list1[i] < list2[j]) {
                list[count + 1] = list1[i];
                ++count;
                ++i;
                continue;
            }
            if (list1[i] > list2[j]) {
                list[count + 1] = list2[j];
                ++count;
                ++j;
                continue;
            }
            list[count + 1] = list1[i];
            ++count;
            ++i;
            ++j;
        }
        if (i > list1[0]) {
            for (k = j; k <= list2[0]; ++k) {
                list[count + 1] = list2[k];
                ++count;
            }
        }
        if (j > list2[0]) {
            for (k = i; k <= list1[0]; ++k) {
                list[count + 1] = list1[k];
                ++count;
            }
        }
        list[0] = count;
        return list;
    }

    public final Results errors(M5Instances inst) throws Exception {
        Results e = new Results(0, inst.numInstances() - 1);
        for (int i = 0; i <= inst.numInstances() - 1; ++i) {
            double tmp = this.predict(inst.instance(i)) - inst.instance(i).classValue();
            e.sumErr += tmp;
            e.sumAbsErr += Math.abs(tmp);
            e.sumSqrErr += tmp * tmp;
        }
        e.meanAbsErr = e.sumAbsErr / (double)e.numInstances;
        e.meanSqrErr = (e.sumSqrErr - e.sumErr * e.sumErr / (double)e.numInstances) / (double)e.numInstances;
        e.meanSqrErr = Math.abs(e.meanSqrErr);
        e.rootMeanSqrErr = Math.sqrt(e.meanSqrErr);
        return e;
    }

    public final double predict(M5Instance instance) {
        double y = this.coeffs[0];
        for (int j = 1; j <= this.terms[0]; ++j) {
            y += this.coeffs[j] * instance.value(this.terms[j]);
        }
        return y;
    }

    public final int insignificant(double sdy, M5Instances inst) {
        int jmin = -1;
        int jmax = -1;
        double min = 2.0;
        double max = 2.5;
        for (int j = 1; j <= this.terms[0]; ++j) {
            double sdx = M5.stdDev(this.terms[j], inst);
            double contribution = sdy == 0.0 ? 0.0 : Math.abs(this.coeffs[j] * sdx / sdy);
            if (contribution < min) {
                min = contribution;
                jmin = j;
            }
            if (!(contribution > max)) continue;
            max = contribution;
            jmax = j;
        }
        if (max > 2.5) {
            jmin = jmax;
        }
        return jmin;
    }

    public final Function remove(int j) {
        int i;
        Function f = new Function();
        f.terms = new int[this.terms[0]];
        f.terms[0] = this.terms[0] - 1;
        for (i = 1; i < j; ++i) {
            f.terms[i] = this.terms[i];
        }
        for (i = j; i <= this.terms[0] - 1; ++i) {
            f.terms[i] = this.terms[i + 1];
        }
        f.coeffs = new double[f.terms[0] + 1];
        return f;
    }
}

