/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IMutator;
import net.sf.jclec.IPopulation;
import net.sf.jclec.ISystem;
import net.sf.jclec.util.random.IRandGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutator<I extends IIndividual>
implements IMutator<I> {
    protected IPopulation<I> context;
    protected IRandGen randgen;
    protected transient List<I> parentsBuffer;
    protected transient List<I> sonsBuffer;
    protected transient int parentsCounter;

    @Override
    public void contextualize(ISystem<I> context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
        this.randgen = context.createRandGen();
    }

    @Override
    public List<I> mutate(List<I> parents) {
        this.parentsBuffer = parents;
        this.prepareMutation();
        this.sonsBuffer = new ArrayList<I>();
        this.parentsCounter = 0;
        while (this.parentsCounter < parents.size()) {
            this.mutateNext();
            ++this.parentsCounter;
        }
        return this.sonsBuffer;
    }

    protected abstract void prepareMutation();

    protected abstract void mutateNext();
}

