/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree.mut;

import net.sourceforge.jclec.syntaxtree.IMutateSyntaxTree;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.util.random.IRandGen;

public class ExpandNTMutator
implements IMutateSyntaxTree {
    private static final long serialVersionUID = -2706522794304044852L;

    public boolean equals(Object other) {
        return other instanceof ExpandNTMutator;
    }

    @Override
    public SyntaxTree mutateSyntaxTree(SyntaxTree parent, SyntaxTreeSchema schema, IRandGen randgen) {
        SyntaxTree son = new SyntaxTree();
        int p0_branchStart = this.selectSymbol(parent, schema, randgen);
        if (p0_branchStart == -1) {
            int i = 0;
            while (i < parent.size()) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
            return son;
        }
        NonTerminalNode selectedSymbol = (NonTerminalNode)parent.getNode(p0_branchStart);
        int p0_branchEnd = parent.subTree(p0_branchStart);
        int p0_branchDepth = parent.derivSize();
        int p0_swapBranch = 0;
        int i = p0_branchStart;
        while (i < p0_branchEnd) {
            if (parent.getNode(i).arity() != 0) {
                ++p0_swapBranch;
            }
            ++i;
        }
        i = 0;
        while (i < p0_branchStart) {
            son.addNode(parent.getNode(i).copy());
            ++i;
        }
        int nMaxOfDer = schema.getMaxDerivSize() - p0_branchDepth + p0_swapBranch;
        int nOfDer = randgen.choose(p0_swapBranch + 1, nMaxOfDer);
        schema.fillSyntaxBranch(son, selectedSymbol.getSymbol(), nOfDer, randgen);
        int i2 = p0_branchEnd;
        while (i2 < parent.size()) {
            son.addNode(parent.getNode(i2).copy());
            ++i2;
        }
        return son;
    }

    private final int selectSymbol(SyntaxTree tree, SyntaxTreeSchema schema, IRandGen randgen) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (!schema.isTerminal(tree.getNode(actPos).getSymbol())) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }
}

