/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.BasicMethods;

import java.util.ArrayList;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class CNN
extends PrototypeGenerator {
    protected int k = 1;

    public CNN(PrototypeSet _trainingDataSet) {
        super(_trainingDataSet);
        this.algorithmName = "CNN";
    }

    public CNN(PrototypeSet _trainingDataSet, int k) {
        super(_trainingDataSet);
        this.algorithmName = "CNN";
        this.k = k;
    }

    public static PrototypeSet makeReductionOf(PrototypeSet original) {
        PrototypeSet T = original.copy();
        T.randomize();
        PrototypeSet S = new PrototypeSet();
        ArrayList<Double> classes = T.nonVoidClasses();
        for (double c : classes) {
            PrototypeSet Tc = T.getFromClass(c);
            Tc.randomize();
            S.add(Tc.get(0));
            T.remove((Prototype)Tc.get(0));
        }
        int Tsize = T.size();
        for (int i = 0; i < Tsize; ++i) {
            Prototype ti = (Prototype)T.get(i);
            Prototype s = KNN.getNearest(ti, S);
            if (s.label() == ti.label()) continue;
            S.add(ti);
        }
        return S;
    }

    public static PrototypeSet makeReductionOf(PrototypeSet original, int k) {
        PrototypeSet T = original.copy();
        T.randomize();
        PrototypeSet S = new PrototypeSet();
        ArrayList<Double> classes = T.nonVoidClasses();
        for (double c : classes) {
            PrototypeSet Tc = T.getFromClass(c);
            Tc.randomize();
            S.add(Tc.get(0));
            T.remove((Prototype)Tc.get(0));
        }
        int Tsize = T.size();
        for (int i = 0; i < Tsize; ++i) {
            Prototype ti = (Prototype)T.get(i);
            double tiLabel = ti.label();
            PrototypeSet nearest = KNN.getNearestNeighbors(ti, S, k);
            double nearestSetLabel = nearest.mostFrequentClass();
            if (nearestSetLabel == tiLabel || tiLabel == ((Prototype)nearest.get(0)).label()) continue;
            S.add(ti);
        }
        return S;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet reduced = null;
        reduced = this.k > 1 ? CNN.makeReductionOf(this.trainingDataSet, this.k) : CNN.makeReductionOf(this.trainingDataSet);
        return reduced;
    }

    public static void main(String[] args) {
        Parameters.setUse("CNN", "<seed>");
        Parameters.assertBasicArgs(args);
        Debug.setStdDebugMode(true);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        CNN.setSeed(seed);
        CNN cnn = new CNN(training);
        PrototypeSet resultingSet = cnn.reduceSet();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        cnn.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

