/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.multisyntaxtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractMutator;
import net.sourceforge.jclec.multisyntaxtree.MultiSyntaxTreeIndividual;
import net.sourceforge.jclec.multisyntaxtree.MultiSyntaxTreeSpecies;
import net.sourceforge.jclec.syntaxtree.IMutateSyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class MultiSyntaxTreeMutator
extends AbstractMutator
implements IConfigure {
    protected int targetTreeIndex = -1;
    protected IMutateSyntaxTree baseOp;
    protected transient MultiSyntaxTreeSpecies species;
    protected transient SyntaxTreeSchema[] schema;

    public int getTargetTreeIndex() {
        return this.targetTreeIndex;
    }

    public void setTargetTreeIndex(int targetTreeIndex) {
        this.targetTreeIndex = targetTreeIndex;
    }

    public IMutateSyntaxTree getBaseOp() {
        return this.baseOp;
    }

    public void setBaseOp(IMutateSyntaxTree baseOp) {
        this.baseOp = baseOp;
    }

    @Override
    public void configure(Configuration settings) {
        int targetTreeIndex = settings.getInt("target-tree-index", -1);
        this.setTargetTreeIndex(targetTreeIndex);
        try {
            String baseOpClassname = settings.getString("base-op[@type]");
            Class<?> baseOpClass = Class.forName(baseOpClassname);
            IMutateSyntaxTree baseOp = (IMutateSyntaxTree)baseOpClass.newInstance();
            if (baseOp instanceof IConfigure) {
                ((IConfigure)((Object)baseOp)).configure(settings.subset("base-op"));
            }
            this.setBaseOp(baseOp);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal operator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
    }

    @Override
    protected void prepareMutation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof MultiSyntaxTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (MultiSyntaxTreeSpecies)spc;
        this.schema = ((MultiSyntaxTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void mutateNext() {
        int nOfSyntaxTrees = this.species.numberOfSyntaxTrees();
        int actTargetExprIndex = this.targetTreeIndex == -1 ? this.randgen.choose(0, nOfSyntaxTrees) : this.targetTreeIndex;
        SyntaxTree[] parentGenotype = (SyntaxTree[])((MultiSyntaxTreeIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        SyntaxTree[] sonGenotype = new SyntaxTree[nOfSyntaxTrees];
        int i = 0;
        while (i < nOfSyntaxTrees) {
            sonGenotype[i] = i == actTargetExprIndex ? this.baseOp.mutateSyntaxTree(parentGenotype[i], this.schema[i], this.randgen) : parentGenotype[i].copy();
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(sonGenotype));
    }
}

