/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsMatrix;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TsDataVintages<T extends Comparable> {
    private SortedMap<TsPeriod, SortedMap<T, Double>> data_ = new TreeMap<TsPeriod, SortedMap<T, Double>>();

    public void add(TsPeriod period, double value, T vintage) {
        TreeMap<T, Double> cur = (TreeMap<T, Double>)this.data_.get(period);
        if (cur == null) {
            cur = new TreeMap<T, Double>();
            this.data_.put(period, cur);
        }
        cur.put(vintage, value);
    }

    public void add(TsData data, T vintage) {
        for (int i = 0; i < data.getLength(); ++i) {
            this.add(data.getDomain().get(i), data.get(i), vintage);
        }
    }

    public T lastVintage(TsPeriod p) {
        SortedMap cur = (SortedMap)this.data_.get(p);
        if (cur == null) {
            return null;
        }
        return (T)((Comparable)cur.lastKey());
    }

    public TsData current() {
        TsPeriod start = this.data_.firstKey();
        TsPeriod end = this.data_.lastKey();
        TsData rslt = new TsData(start, end.minus(start) + 1);
        for (Map.Entry<TsPeriod, SortedMap<T, Double>> cur : this.data_.entrySet()) {
            int pos = cur.getKey().minus(start);
            SortedMap<T, Double> map = cur.getValue();
            double val = (Double)map.get(map.lastKey());
            rslt.set(pos, val);
        }
        return rslt;
    }

    public TsData initial() {
        TsPeriod start = this.data_.firstKey();
        TsPeriod end = this.data_.lastKey();
        TsData rslt = new TsData(start, end.minus(start) + 1);
        for (Map.Entry<TsPeriod, SortedMap<T, Double>> cur : this.data_.entrySet()) {
            int pos = cur.getKey().minus(start);
            SortedMap<T, Double> map = cur.getValue();
            double val = (Double)map.get(map.firstKey());
            rslt.set(pos, val);
        }
        return rslt;
    }

    public TsData data(T vintage, boolean exactVintage) {
        TsPeriod start = this.data_.firstKey();
        TsPeriod end = this.data_.lastKey();
        TsData rslt = new TsData(start, end.minus(start) + 1);
        for (Map.Entry<TsPeriod, SortedMap<T, Double>> cur : this.data_.entrySet()) {
            SortedMap<T, Double> head;
            int pos = cur.getKey().minus(start);
            SortedMap<T, Double> map = cur.getValue();
            Double val = (Double)map.get(vintage);
            if (val == null && !exactVintage && !(head = map.headMap(vintage)).isEmpty()) {
                val = (Double)map.get(head.lastKey());
            }
            if (val == null) continue;
            rslt.set(pos, (double)val);
        }
        return rslt;
    }

    public SortedMap<T, Double> vintages(TsPeriod p) {
        return (SortedMap)this.data_.get(p);
    }

    public SortedSet<T> allVintages() {
        TreeSet<Comparable> set = new TreeSet<Comparable>();
        for (Map.Entry<TsPeriod, SortedMap<T, Double>> cur : this.data_.entrySet()) {
            for (Comparable t : cur.getValue().keySet()) {
                if (set.contains(t)) continue;
                set.add(t);
            }
        }
        return set;
    }

    public double[] dataVintages(TsPeriod p) {
        SortedMap<T, Double> v = this.vintages(p);
        if (v == null) {
            return null;
        }
        double[] vals = new double[v.size()];
        int i = 0;
        for (Double x : v.values()) {
            vals[i++] = x;
        }
        return vals;
    }

    public TsMatrix toMatrix(Collection<T> vintages, boolean exactVintages) {
        TsData[] s = new TsData[vintages.size()];
        int i = 0;
        for (Comparable t : vintages) {
            s[i++] = this.data(t, exactVintages);
        }
        return new TsMatrix(s);
    }
}

