/*
 * Decompiled with CFR 0.152.
 */
package javalain.ea;

import java.text.DecimalFormat;
import javalain.ea.SolutionEA;
import util.GuiUtils;

public class Solution
implements SolutionEA {
    private static DecimalFormat DF = GuiUtils.DECIMAL_3;
    private double[] variable;
    private double[] objectif;
    private double crowdingDistance = 0.0;
    private int rank = 0;

    public Solution(double[] pVariable) {
        this.variable = new double[pVariable.length];
        System.arraycopy(pVariable, 0, this.variable, 0, pVariable.length);
    }

    public Solution(double[] pVariable, double[] pObjectifs) {
        this.variable = new double[pVariable.length];
        System.arraycopy(pVariable, 0, this.variable, 0, pVariable.length);
        this.objectif = new double[pObjectifs.length];
        System.arraycopy(pObjectifs, 0, this.objectif, 0, pObjectifs.length);
    }

    public int getNbVariable() {
        return this.variable.length;
    }

    public int getNbObjectif() {
        return this.objectif.length;
    }

    @Override
    public double[] getVariable() {
        return this.variable;
    }

    public double getVariable(int i) {
        return this.variable[i];
    }

    public void setVariable(int i, double d) {
        this.variable[i] = d;
    }

    @Override
    public double[] getObjectif() {
        return this.objectif;
    }

    public double getObjectif(int i) {
        return this.objectif[i];
    }

    @Override
    public double getCrowdingDistance() {
        return this.crowdingDistance;
    }

    @Override
    public void setCrowdingDistance(double pCrowdingDistance) {
        this.crowdingDistance = pCrowdingDistance;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public void setRank(int pRank) {
        this.rank = pRank;
    }

    public static void setDecimalFormat(DecimalFormat df) {
        DF = df;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Solution s = (Solution)obj;
        if (this.objectif.length != s.objectif.length) {
            return false;
        }
        for (int i = 0; i < this.objectif.length; ++i) {
            if (this.objectif[i] == s.objectif[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("x(");
        for (i = 0; i < this.variable.length - 1; ++i) {
            sb.append(DF.format(this.variable[i])).append(" ");
        }
        sb.append(DF.format(this.variable[this.variable.length - 1])).append(") ");
        sb.append("f(");
        for (i = 0; i < this.objectif.length - 1; ++i) {
            sb.append(DF.format(this.objectif[i])).append(" ");
        }
        sb.append(DF.format(this.objectif[this.objectif.length - 1])).append(")");
        sb.append(" Rank : ").append(this.rank);
        sb.append(" Crowding distance : ").append(DF.format(this.crowdingDistance));
        return sb.toString();
    }
}

