/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;

public class SquareMathFunction
implements MathFunctionWithFirstDerivative {
    private MathFunction func;
    private double a;
    private double b;

    public SquareMathFunction(MathFunction mathFunction) {
        this(mathFunction, 1.0, 0.0);
    }

    public SquareMathFunction(MathFunction mathFunction, double d, double d2) {
        if (mathFunction == null) {
            throw new NullPointerException();
        }
        this.func = mathFunction;
        this.a = d;
        this.b = d2;
    }

    public MathFunction getFunction() {
        return this.func;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double evaluate(double d) {
        double d2 = this.a * this.func.evaluate(d) + this.b;
        return d2 * d2;
    }

    public double derivative(double d) {
        double d2 = MathFunctionUtil.derivative(this.func, d);
        return 2.0 * this.a * (this.a * this.func.evaluate(d) + this.b) * d2;
    }
}

