/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix1D;

class SelectedDenseObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseObjectMatrix2D(Object[] objectArray, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, objectArray, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected SelectedDenseObjectMatrix2D(int n, int n2, Object[] objectArray, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = objectArray;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    public Object elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public Object getQuick(int n, int n2) {
        return this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D instanceof SelectedDenseObjectMatrix2D) {
            SelectedDenseObjectMatrix2D selectedDenseObjectMatrix2D = (SelectedDenseObjectMatrix2D)objectMatrix2D;
            return this.elements == selectedDenseObjectMatrix2D.elements;
        }
        if (objectMatrix2D instanceof DenseObjectMatrix2D) {
            DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
            return this.elements == denseObjectMatrix2D.elements;
        }
        return false;
    }

    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new DenseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new DenseObjectMatrix1D(n);
    }

    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public void setQuick(int n, int n2, Object object) {
        this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]] = object;
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    public ObjectMatrix1D vectorize() {
        DenseObjectMatrix1D denseObjectMatrix1D = new DenseObjectMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                denseObjectMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return denseObjectMatrix1D;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    public ObjectMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedDenseObjectMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public ObjectMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedDenseObjectMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseObjectMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

