/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongFactory1D;
import cern.colt.matrix.tlong.LongFactory2D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix1DProcedure;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.jet.math.tlong.LongFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import junit.framework.TestCase;

public abstract class LongMatrix2DTest
extends TestCase {
    protected LongMatrix2D A;
    protected LongMatrix2D B;
    protected LongMatrix2D Bt;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected Random rand = new Random(0L);

    public LongMatrix2DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                this.A.setQuick(n2, n, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
            }
        }
        for (n2 = 0; n2 < this.B.rows(); ++n2) {
            for (n = 0; n < this.B.columns(); ++n) {
                this.B.setQuick(n2, n, Math.max(1L, this.rand.nextLong() % (long)this.B.rows()));
            }
        }
        for (n2 = 0; n2 < this.Bt.rows(); ++n2) {
            for (n = 0; n < this.Bt.columns(); ++n) {
                this.Bt.setQuick(n2, n, Math.max(1L, this.rand.nextLong() % (long)this.Bt.rows()));
            }
        }
    }

    protected void tearDown() throws Exception {
        this.Bt = null;
        this.B = null;
        this.A = null;
    }

    public void testAggregateLongLongFunctionLongFunction() {
        long l = 0L;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                long l2 = this.A.getQuick(i, j);
                l += l2 * l2;
            }
        }
        long l3 = this.A.aggregate(LongFunctions.plus, LongFunctions.square);
        LongMatrix2DTest.assertEquals((long)l, (long)l3);
    }

    public void testAggregateLongLongFunctionLongFunctionLongProcedure() {
        LongProcedure longProcedure = new LongProcedure(){

            public boolean apply(long l) {
                return (double)Math.abs(l) > 0.2;
            }
        };
        long l = 0L;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                long l2 = this.A.getQuick(i, j);
                if (!((double)Math.abs(l2) > 0.2)) continue;
                l += l2 * l2;
            }
        }
        long l3 = this.A.aggregate(LongFunctions.plus, LongFunctions.square, longProcedure);
        LongMatrix2DTest.assertEquals((long)l, (long)l3);
    }

    public void testAggregateLongLongFunctionLongFunctionIntArrayListIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                intArrayList.add(i);
                intArrayList2.add(j);
            }
        }
        long l = 0L;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                long l2 = this.A.getQuick(i, j);
                l += l2 * l2;
            }
        }
        long l3 = this.A.aggregate(LongFunctions.plus, LongFunctions.square, intArrayList, intArrayList2);
        LongMatrix2DTest.assertEquals((long)l, (long)l3);
    }

    public void testAggregateLongMatrix2DLongLongFunctionLongLongFunction() {
        long l = 0L;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                long l2 = this.A.getQuick(i, j);
                long l3 = this.B.getQuick(i, j);
                l += l2 * l3;
            }
        }
        long l4 = this.A.aggregate(this.B, LongFunctions.plus, LongFunctions.mult);
        LongMatrix2DTest.assertEquals((long)l, (long)l4);
    }

    public void testAssignLong() {
        long l = this.rand.nextLong();
        this.A.assign(l);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, longArrayList);
        for (int i = 0; i < longArrayList.size(); ++i) {
            LongMatrix2DTest.assertEquals((long)l, (long)longArrayList.getQuick(i));
        }
    }

    public void testAssignLongArrayArray() {
        int n;
        int n2;
        long[][] lArray = new long[this.A.rows()][this.A.columns()];
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                lArray[n2][n] = this.rand.nextLong();
            }
        }
        this.A.assign(lArray);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            LongMatrix2DTest.assertTrue((this.A.columns() == lArray[n2].length ? 1 : 0) != 0);
            for (n = 0; n < this.A.columns(); ++n) {
                LongMatrix2DTest.assertEquals((long)lArray[n2][n], (long)this.A.getQuick(n2, n));
            }
        }
    }

    public void testAssignLongFunction() {
        LongMatrix2D longMatrix2D = this.A.copy();
        this.A.assign(LongFunctions.neg);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                long l = -longMatrix2D.getQuick(i, j);
                LongMatrix2DTest.assertEquals((long)l, (long)this.A.getQuick(i, j));
            }
        }
    }

    public void testAssignLongMatrix2D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                LongMatrix2DTest.assertEquals((long)this.B.getQuick(i, j), (long)this.A.getQuick(i, j));
            }
        }
    }

    public void testAssignLongMatrix2DLongLongFunction() {
        LongMatrix2D longMatrix2D = this.A.copy();
        this.A.assign(this.B, LongFunctions.plus);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                LongMatrix2DTest.assertEquals((long)(longMatrix2D.getQuick(i, j) + this.B.getQuick(i, j)), (long)this.A.getQuick(i, j));
            }
        }
    }

    public void testAssignLongMatrix2DLongLongFunctionIntArrayListIntArrayList() {
        int n;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (n = 0; n < this.A.columns(); ++n) {
                intArrayList.add(i);
                intArrayList2.add(n);
            }
        }
        LongMatrix2D longMatrix2D = this.A.copy();
        this.A.assign(this.B, LongFunctions.plus, intArrayList, intArrayList2);
        for (n = 0; n < this.A.rows(); ++n) {
            for (int i = 0; i < this.A.columns(); ++i) {
                LongMatrix2DTest.assertEquals((long)(longMatrix2D.getQuick(n, i) + this.B.getQuick(n, i)), (long)this.A.getQuick(n, i));
            }
        }
    }

    public void testAssignLongProcedureLong() {
        LongProcedure longProcedure = new LongProcedure(){

            public boolean apply(long l) {
                return Math.abs(l) > 1L;
            }
        };
        LongMatrix2D longMatrix2D = this.A.copy();
        this.A.assign(longProcedure, -1L);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if (Math.abs(longMatrix2D.getQuick(i, j)) > 1L) {
                    LongMatrix2DTest.assertEquals((long)-1L, (long)this.A.getQuick(i, j));
                    continue;
                }
                LongMatrix2DTest.assertEquals((long)longMatrix2D.getQuick(i, j), (long)this.A.getQuick(i, j));
            }
        }
    }

    public void testAssignLongProcedureLongFunction() {
        LongProcedure longProcedure = new LongProcedure(){

            public boolean apply(long l) {
                return Math.abs(l) > 1L;
            }
        };
        LongMatrix2D longMatrix2D = this.A.copy();
        this.A.assign(longProcedure, LongFunctions.neg);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if (Math.abs(longMatrix2D.getQuick(i, j)) > 1L) {
                    LongMatrix2DTest.assertEquals((long)(-longMatrix2D.getQuick(i, j)), (long)this.A.getQuick(i, j));
                    continue;
                }
                LongMatrix2DTest.assertEquals((long)longMatrix2D.getQuick(i, j), (long)this.A.getQuick(i, j));
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        int n2 = 0;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if (this.A.getQuick(i, j) == 0L) continue;
                ++n2;
            }
        }
        LongMatrix2DTest.assertEquals((int)n2, (int)n);
    }

    public void testEqualsLong() {
        long l = 1L;
        this.A.assign(l);
        boolean bl = this.A.equals(l);
        LongMatrix2DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2L);
        LongMatrix2DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        LongMatrix2DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        LongMatrix2DTest.assertFalse((boolean)bl);
    }

    public void testForEachNonZero() {
        LongMatrix2D longMatrix2D = this.A.copy();
        IntIntLongFunction intIntLongFunction = new IntIntLongFunction(){

            public long apply(int n, int n2, long l) {
                return -l;
            }
        };
        this.A.forEachNonZero(intIntLongFunction);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                LongMatrix2DTest.assertEquals((long)(-longMatrix2D.getQuick(i, j)), (long)this.A.getQuick(i, j));
            }
        }
    }

    public void testMaxLocation() {
        this.A.assign(0L);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 7L);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 1L);
        long[] lArray = this.A.getMaxLocation();
        LongMatrix2DTest.assertEquals((long)7L, (long)lArray[0]);
        LongMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)((int)lArray[1]));
        LongMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)((int)lArray[2]));
    }

    public void testMinLocation() {
        this.A.assign(0L);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, -7L);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, -1L);
        long[] lArray = this.A.getMinLocation();
        LongMatrix2DTest.assertEquals((long)-7L, (long)lArray[0]);
        LongMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)((int)lArray[1]));
        LongMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)((int)lArray[2]));
    }

    public void testGetNegativeValues() {
        this.A.assign(0L);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, -7L);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, -1L);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getNegativeValues(intArrayList, intArrayList2, longArrayList);
        LongMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        LongMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        LongMatrix2DTest.assertEquals((int)2, (int)longArrayList.size());
        LongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        LongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        LongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        LongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        LongMatrix2DTest.assertTrue((boolean)longArrayList.contains(-7L));
        LongMatrix2DTest.assertTrue((boolean)longArrayList.contains(-1L));
    }

    public void testGetNonZeros() {
        this.A.assign(0L);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 7L);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 1L);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, longArrayList);
        LongMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        LongMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        LongMatrix2DTest.assertEquals((int)2, (int)longArrayList.size());
        LongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        LongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        LongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        LongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        LongMatrix2DTest.assertTrue((boolean)longArrayList.contains(7L));
        LongMatrix2DTest.assertTrue((boolean)longArrayList.contains(1L));
    }

    public void testGetPositiveValues() {
        this.A.assign(0L);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 7L);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 1L);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getPositiveValues(intArrayList, intArrayList2, longArrayList);
        LongMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        LongMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        LongMatrix2DTest.assertEquals((int)2, (int)longArrayList.size());
        LongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        LongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        LongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        LongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        LongMatrix2DTest.assertTrue((boolean)longArrayList.contains(7L));
        LongMatrix2DTest.assertTrue((boolean)longArrayList.contains(1L));
    }

    public void testToArray() {
        long[][] lArray = this.A.toArray();
        LongMatrix2DTest.assertTrue((this.A.rows() == lArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.A.rows(); ++i) {
            LongMatrix2DTest.assertTrue((this.A.columns() == lArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.A.columns(); ++j) {
                LongMatrix2DTest.assertEquals((long)0L, (long)Math.abs(lArray[i][j] - this.A.getQuick(i, j)));
            }
        }
    }

    public void testVectorize() {
        LongMatrix1D longMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.A.columns(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                LongMatrix2DTest.assertEquals((long)this.A.getQuick(j, i), (long)longMatrix1D.getQuick(n++));
            }
        }
    }

    public void testViewColumn() {
        LongMatrix1D longMatrix1D = this.A.viewColumn(this.A.columns() / 2);
        LongMatrix2DTest.assertEquals((long)this.A.rows(), (long)longMatrix1D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            LongMatrix2DTest.assertEquals((long)this.A.getQuick(i, this.A.columns() / 2), (long)longMatrix1D.getQuick(i));
        }
    }

    public void testViewColumnFlip() {
        LongMatrix2D longMatrix2D = this.A.viewColumnFlip();
        LongMatrix2DTest.assertEquals((long)this.A.size(), (long)longMatrix2D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                LongMatrix2DTest.assertEquals((long)this.A.getQuick(i, this.A.columns() - 1 - j), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewDice() {
        LongMatrix2D longMatrix2D = this.A.viewDice();
        LongMatrix2DTest.assertEquals((int)this.A.rows(), (int)longMatrix2D.columns());
        LongMatrix2DTest.assertEquals((int)this.A.columns(), (int)longMatrix2D.rows());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                LongMatrix2DTest.assertEquals((long)this.A.getQuick(i, j), (long)longMatrix2D.getQuick(j, i));
            }
        }
    }

    public void testViewPart() {
        LongMatrix2D longMatrix2D = this.A.viewPart(this.A.rows() / 2, this.A.columns() / 2, this.A.rows() / 3, this.A.columns() / 3);
        LongMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)longMatrix2D.rows());
        LongMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)longMatrix2D.columns());
        for (int i = 0; i < this.A.rows() / 3; ++i) {
            for (int j = 0; j < this.A.columns() / 3; ++j) {
                LongMatrix2DTest.assertEquals((long)this.A.getQuick(this.A.rows() / 2 + i, this.A.columns() / 2 + j), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewRow() {
        LongMatrix1D longMatrix1D = this.A.viewRow(this.A.rows() / 2);
        LongMatrix2DTest.assertEquals((long)this.A.columns(), (long)longMatrix1D.size());
        for (int i = 0; i < this.A.columns(); ++i) {
            LongMatrix2DTest.assertEquals((long)this.A.getQuick(this.A.rows() / 2, i), (long)longMatrix1D.getQuick(i));
        }
    }

    public void testViewRowFlip() {
        LongMatrix2D longMatrix2D = this.A.viewRowFlip();
        LongMatrix2DTest.assertEquals((long)this.A.size(), (long)longMatrix2D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                LongMatrix2DTest.assertEquals((long)this.A.getQuick(this.A.rows() - 1 - i, j), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSelectionLongMatrix1DProcedure() {
        this.A.assign(0L);
        this.A.setQuick(this.A.rows() / 4, 0, 2L);
        this.A.setQuick(this.A.rows() / 2, 0, 2L);
        LongMatrix2D longMatrix2D = this.A.viewSelection(new LongMatrix1DProcedure(){

            public boolean apply(LongMatrix1D longMatrix1D) {
                return Math.abs(longMatrix1D.getQuick(0) - 2L) == 0L;
            }
        });
        LongMatrix2DTest.assertEquals((int)2, (int)longMatrix2D.rows());
        LongMatrix2DTest.assertEquals((int)this.A.columns(), (int)longMatrix2D.columns());
        LongMatrix2DTest.assertEquals((long)this.A.getQuick(this.A.rows() / 4, 0), (long)longMatrix2D.getQuick(0, 0));
        LongMatrix2DTest.assertEquals((long)this.A.getQuick(this.A.rows() / 2, 0), (long)longMatrix2D.getQuick(1, 0));
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.A.rows() / 6, this.A.rows() / 5, this.A.rows() / 4, this.A.rows() / 3, this.A.rows() / 2};
        int[] nArray2 = new int[]{this.A.columns() / 6, this.A.columns() / 5, this.A.columns() / 4, this.A.columns() / 3, this.A.columns() / 2, this.A.columns() - 1};
        LongMatrix2D longMatrix2D = this.A.viewSelection(nArray, nArray2);
        LongMatrix2DTest.assertEquals((int)nArray.length, (int)longMatrix2D.rows());
        LongMatrix2DTest.assertEquals((int)nArray2.length, (int)longMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                LongMatrix2DTest.assertEquals((long)this.A.getQuick(nArray[i], nArray2[j]), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSorted() {
        LongMatrix2D longMatrix2D = this.A.viewSorted(1);
        for (int i = 0; i < this.A.rows() - 1; ++i) {
            LongMatrix2DTest.assertTrue((longMatrix2D.getQuick(i + 1, 1) >= longMatrix2D.getQuick(i, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        LongMatrix2D longMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < longMatrix2D.rows(); ++i) {
            for (int j = 0; j < longMatrix2D.columns(); ++j) {
                LongMatrix2DTest.assertEquals((long)this.A.getQuick(i * n, j * n2), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testZMultLongMatrix1DLongMatrix1DLongLongBoolean() {
        int n;
        long l;
        int n2;
        DenseLongMatrix1D denseLongMatrix1D = new DenseLongMatrix1D(this.A.columns());
        int n3 = 0;
        while ((long)n3 < denseLongMatrix1D.size()) {
            ((LongMatrix1D)denseLongMatrix1D).setQuick(n3, this.rand.nextLong() % (long)this.A.rows());
            ++n3;
        }
        long l2 = 3L;
        long l3 = 5L;
        LongMatrix1D longMatrix1D = LongFactory1D.dense.random(this.A.rows());
        longMatrix1D.assign(LongFunctions.mod(this.A.rows()));
        long[] lArray = longMatrix1D.toArray();
        longMatrix1D = this.A.zMult(denseLongMatrix1D, longMatrix1D, l2, l3, false);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            l = 0L;
            for (n = 0; n < this.A.columns(); ++n) {
                l += this.A.getQuick(n2, n) * ((LongMatrix1D)denseLongMatrix1D).getQuick(n);
            }
            lArray[n2] = l * l2 + lArray[n2] * l3;
        }
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            LongMatrix2DTest.assertEquals((long)lArray[n2], (long)longMatrix1D.getQuick(n2));
        }
        longMatrix1D = null;
        longMatrix1D = this.A.zMult(denseLongMatrix1D, longMatrix1D, l2, l3, false);
        lArray = new long[this.A.rows()];
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            l = 0L;
            for (n = 0; n < this.A.columns(); ++n) {
                l += this.A.getQuick(n2, n) * ((LongMatrix1D)denseLongMatrix1D).getQuick(n);
            }
            lArray[n2] = l * l2;
        }
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            LongMatrix2DTest.assertEquals((long)lArray[n2], (long)longMatrix1D.getQuick(n2));
        }
        denseLongMatrix1D = new DenseLongMatrix1D(this.A.rows());
        n2 = 0;
        while ((long)n2 < denseLongMatrix1D.size()) {
            ((LongMatrix1D)denseLongMatrix1D).setQuick(n2, this.rand.nextLong() % (long)this.A.rows());
            ++n2;
        }
        longMatrix1D = LongFactory1D.dense.random(this.A.columns());
        longMatrix1D.assign(LongFunctions.mod(this.A.rows()));
        lArray = longMatrix1D.toArray();
        longMatrix1D = this.A.zMult(denseLongMatrix1D, longMatrix1D, l2, l3, true);
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            l = 0L;
            for (n = 0; n < this.A.rows(); ++n) {
                l += this.A.getQuick(n, n2) * ((LongMatrix1D)denseLongMatrix1D).getQuick(n);
            }
            lArray[n2] = l * l2 + lArray[n2] * l3;
        }
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            LongMatrix2DTest.assertEquals((long)lArray[n2], (long)longMatrix1D.getQuick(n2));
        }
        longMatrix1D = null;
        longMatrix1D = this.A.zMult(denseLongMatrix1D, longMatrix1D, l2, l3, true);
        lArray = new long[this.A.columns()];
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            l = 0L;
            for (n = 0; n < this.A.rows(); ++n) {
                l += this.A.getQuick(n, n2) * ((LongMatrix1D)denseLongMatrix1D).getQuick(n);
            }
            lArray[n2] = l * l2;
        }
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            LongMatrix2DTest.assertEquals((long)lArray[n2], (long)longMatrix1D.getQuick(n2));
        }
    }

    public void testZMultLongMatrix2DLongMatrix2DLongLongBooleanBoolean() {
        int n;
        long l;
        int n2;
        int n3;
        long l2 = 3L;
        long l3 = 5L;
        LongMatrix2D longMatrix2D = LongFactory2D.dense.random(this.A.rows(), this.A.rows());
        longMatrix2D.assign(LongFunctions.mod(this.A.rows()));
        long[][] lArray = longMatrix2D.toArray();
        longMatrix2D = this.A.zMult(this.Bt, longMatrix2D, l2, l3, false, false);
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                l = 0L;
                for (n = 0; n < this.A.columns(); ++n) {
                    l += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                lArray[n2][n3] = l * l2 + lArray[n2][n3] * l3;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                LongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = null;
        longMatrix2D = this.A.zMult(this.Bt, longMatrix2D, l2, l3, false, false);
        lArray = new long[this.A.rows()][this.A.rows()];
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                l = 0L;
                for (n = 0; n < this.A.columns(); ++n) {
                    l += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                lArray[n2][n3] = l * l2;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                LongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = LongFactory2D.dense.random(this.A.columns(), this.A.columns());
        longMatrix2D.assign(LongFunctions.mod(this.A.rows()));
        lArray = longMatrix2D.toArray();
        longMatrix2D = this.A.zMult(this.B, longMatrix2D, l2, l3, true, false);
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                l = 0L;
                for (n = 0; n < this.A.rows(); ++n) {
                    l += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                lArray[n2][n3] = l * l2 + lArray[n2][n3] * l3;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                LongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = null;
        longMatrix2D = this.A.zMult(this.B, longMatrix2D, l2, l3, true, false);
        lArray = new long[this.A.columns()][this.A.columns()];
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                l = 0L;
                for (n = 0; n < this.A.rows(); ++n) {
                    l += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                lArray[n2][n3] = l * l2;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                LongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = LongFactory2D.dense.random(this.A.rows(), this.A.rows());
        longMatrix2D.assign(LongFunctions.mod(this.A.rows()));
        lArray = longMatrix2D.toArray();
        longMatrix2D = this.A.zMult(this.B, longMatrix2D, l2, l3, false, true);
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                l = 0L;
                for (n = 0; n < this.A.columns(); ++n) {
                    l += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                lArray[n2][n3] = l * l2 + lArray[n2][n3] * l3;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                LongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = null;
        longMatrix2D = this.A.zMult(this.B, longMatrix2D, l2, l3, false, true);
        lArray = new long[this.A.rows()][this.A.rows()];
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                l = 0L;
                for (n = 0; n < this.A.columns(); ++n) {
                    l += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                lArray[n2][n3] = l * l2;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                LongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = LongFactory2D.dense.random(this.A.columns(), this.A.columns());
        longMatrix2D.assign(LongFunctions.mod(this.A.rows()));
        lArray = longMatrix2D.toArray();
        longMatrix2D = this.A.zMult(this.Bt, longMatrix2D, l2, l3, true, true);
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                l = 0L;
                for (n = 0; n < this.A.rows(); ++n) {
                    l += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                lArray[n2][n3] = l * l2 + lArray[n2][n3] * l3;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                LongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = null;
        longMatrix2D = this.A.zMult(this.Bt, longMatrix2D, l2, l3, true, true);
        lArray = new long[this.A.columns()][this.A.columns()];
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                l = 0L;
                for (n = 0; n < this.A.rows(); ++n) {
                    l += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                lArray[n2][n3] = l * l2;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                LongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
    }

    public void testZSum() {
        long l = this.A.zSum();
        long l2 = 0L;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                l2 += this.A.getQuick(i, j);
            }
        }
        LongMatrix2DTest.assertEquals((long)l2, (long)l);
    }
}

