/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc4;

import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.interfaces.IResults;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResultType;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SForwardResultSet;
import com.amazon.jdbc.common.SPreparedStatement;
import com.amazon.jdbc.common.SResultSetMetaData;
import com.amazon.jdbc.jdbc4.S4ForwardResultSet;
import com.amazon.jdbc.jdbc4.S4ParameterMetaData;
import com.amazon.jdbc.jdbc4.S4ResultSetMetaData;
import com.amazon.jdbc.jdbc4.S4UpdatableForwardResultSet;
import com.amazon.support.LogUtilities;
import com.amazon.utilities.JDBCVersion;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class S4PreparedStatement
extends SPreparedStatement {
    public S4PreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC4;
    }

    @Override
    protected ResultSet createResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        SForwardResultSet sForwardResultSet = bl ? new S4UpdatableForwardResultSet(this, iResultSet, this.getLogger()) : new S4ForwardResultSet(this, iResultSet, this.getLogger());
        sForwardResultSet.setFetchSize(n);
        return sForwardResultSet;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                IResults iResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> iterator = iResults.getResultItr();
                if (!iterator.hasNext()) {
                    return null;
                }
                ExecutionResult executionResult = iterator.next();
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    this.setResultSetMetadata(this.createResultSetMetaData(iResultSet));
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SResultSetMetaData createResultSetMetaData(IResultSet iResultSet) throws SQLException {
        try {
            ArrayList<? extends IColumn> arrayList = iResultSet.getSelectColumns();
            if (null == arrayList) {
                return null;
            }
            return new S4ResultSetMetaData(arrayList, this.getLogger(), this.getWarningListener());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S4ParameterMetaData s4ParameterMetaData = null;
                s4ParameterMetaData = new S4ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(s4ParameterMetaData);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

