/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class SampleQuantileLociRates
extends AbstractModel {
    private CompoundParameter lociRates;
    private Parameter rateQuantileParameter;
    private ParametricDistributionModel distrModel;
    private double normalizeRateTo;
    private boolean normalize;
    private double scaleFactor;
    private double[] rates;

    public SampleQuantileLociRates(CompoundParameter compoundParameter, Parameter parameter, ParametricDistributionModel parametricDistributionModel, boolean bl, double d) {
        super("SampleQuantileLociRates");
        this.lociRates = compoundParameter;
        this.rateQuantileParameter = parameter;
        this.distrModel = parametricDistributionModel;
        this.normalizeRateTo = d;
        this.normalize = bl;
        this.rates = new double[parameter.getDimension()];
        this.setupRates();
        this.setupRelativeRates();
        this.addModel(this.distrModel);
        this.addVariable(this.rateQuantileParameter);
    }

    private void setupRates() {
        for (int i = 0; i < this.rates.length; ++i) {
            this.rates[i] = this.distrModel.quantile(this.rateQuantileParameter.getParameterValue(i));
        }
    }

    private void setupRates(int n) {
        this.rates[n] = this.distrModel.quantile(this.rateQuantileParameter.getParameterValue(n));
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.distrModel) {
            this.setupRates();
            this.setupRelativeRates();
            this.fireModelChanged();
        } else if (model == this.rateQuantileParameter) {
            this.setupRates(n);
            this.fireModelChanged(null, n);
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.setupRates(n);
        this.setupRelativeRates();
        this.fireModelChanged(null, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void restoreState() {
    }

    private void setupRelativeRates() {
        if (this.normalize) {
            this.computeFactor();
        }
        int n = this.rateQuantileParameter.getDimension();
        for (int i = 0; i < n; ++i) {
            this.lociRates.setParameterValue(i, this.rates[i] * this.scaleFactor);
        }
    }

    private void computeFactor() {
        double d = 0.0;
        int n = this.rateQuantileParameter.getDimension();
        for (int i = 0; i < n; ++i) {
            d += this.rates[i];
        }
        this.scaleFactor = this.normalizeRateTo / (d / (double)n);
    }
}

