/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.RepeatedMeasuresTraitDataModel;
import dr.evomodel.treedatalikelihood.preorder.ContinuousExtensionDelegate;
import dr.inference.model.AbstractVarianceProportionStatistic;
import dr.math.matrixAlgebra.missingData.MissingOps;
import java.util.Arrays;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class VarianceProportionStatisticEmpirical
extends AbstractVarianceProportionStatistic {
    private final ContinuousExtensionDelegate extensionDelegate;
    private final TreeTrait treeTrait;
    private final ContinuousDataLikelihoodDelegate likelihoodDelegate;
    private final boolean forceResample;

    public VarianceProportionStatisticEmpirical(Tree tree, TreeDataLikelihood treeDataLikelihood, RepeatedMeasuresTraitDataModel repeatedMeasuresTraitDataModel, MultivariateDiffusionModel multivariateDiffusionModel, AbstractVarianceProportionStatistic.MatrixRatios matrixRatios, boolean bl) {
        super(tree, treeDataLikelihood, repeatedMeasuresTraitDataModel, matrixRatios);
        this.treeTrait = treeDataLikelihood.getTreeTrait("tip." + repeatedMeasuresTraitDataModel.getTraitName());
        this.likelihoodDelegate = (ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate();
        this.extensionDelegate = repeatedMeasuresTraitDataModel.getExtensionDelegate(this.likelihoodDelegate, this.treeTrait, treeDataLikelihood.getTree());
        this.forceResample = bl;
    }

    @Override
    protected void updateVarianceComponents() {
        if (this.forceResample) {
            this.likelihoodDelegate.fireModelChanged();
        }
        double[] dArray = (double[])this.treeTrait.getTrait(this.treeLikelihood.getTree(), null);
        double[] dArray2 = this.extensionDelegate.getExtendedValues(dArray);
        this.treeLikelihood.getLogLikelihood();
        int n = this.tree.getExternalNodeCount();
        this.computeVariance(this.diffusionComponent, dArray, n, this.dimTrait);
        this.computeVariance(this.samplingComponent, dArray2, n, this.dimTrait);
        CommonOps.addEquals(this.samplingComponent, -1.0, this.diffusionComponent);
    }

    private void computeVariance(DenseMatrix64F denseMatrix64F, double[] dArray, int n, int n2) {
        double[] dArray2 = new double[n];
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(n2, 1);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(n2, n2);
        Arrays.fill(denseMatrix64F.getData(), 0.0);
        for (int i = 0; i < n; ++i) {
            int n3 = n2 * i;
            DenseMatrix64F denseMatrix64F4 = MissingOps.wrap(dArray, n3, n2, 1, dArray2);
            CommonOps.multTransB(denseMatrix64F4, denseMatrix64F4, denseMatrix64F3);
            CommonOps.addEquals(denseMatrix64F, denseMatrix64F3);
            CommonOps.addEquals(denseMatrix64F2, denseMatrix64F4);
        }
        CommonOps.multTransB(denseMatrix64F2, denseMatrix64F2, denseMatrix64F3);
        CommonOps.addEquals(denseMatrix64F, -1.0 / (double)n, denseMatrix64F3);
        CommonOps.scale(1.0 / (double)n, denseMatrix64F);
    }

    @Override
    protected boolean needToUpdate(int n) {
        return n == 0;
    }
}

