/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import java.util.Arrays;

public class MaskedParameter
extends Parameter.Abstract
implements VariableListener {
    private final Signaling signaling;
    private final Parameter parameter;
    private Parameter maskParameter;
    private Bounds<Double> bounds = null;
    private int[] map;
    private int[] inverseMap;
    private int[] storedMap;
    private int[] storedInverseMap;
    private int length;
    private int equalValue;
    private boolean doNotPropagateChangeUp = false;

    public MaskedParameter(Parameter parameter, Parameter parameter2, boolean bl) {
        this(parameter, parameter2, bl, Signaling.NORMAL);
    }

    private MaskedParameter(Parameter parameter, Parameter parameter2, boolean bl, Signaling signaling) {
        this(parameter, signaling);
        this.addMask(parameter2, bl);
    }

    public MaskedParameter(Parameter parameter) {
        this(parameter, Signaling.NORMAL);
    }

    public MaskedParameter(Parameter parameter, Signaling signaling) {
        this.parameter = parameter;
        parameter.addParameterListener(this);
        this.map = new int[parameter.getDimension()];
        this.inverseMap = new int[parameter.getDimension()];
        this.storedMap = new int[parameter.getDimension()];
        this.storedInverseMap = new int[parameter.getDimension()];
        for (int i = 0; i < this.map.length; ++i) {
            this.map[i] = i;
            this.inverseMap[i] = i;
        }
        this.length = this.map.length;
        this.signaling = signaling;
    }

    public void addMask(Parameter parameter, boolean bl) {
        if (parameter.getDimension() != this.parameter.getDimension()) {
            throw new RuntimeException("Masking parameter '" + parameter.getId() + "' dimension must equal base parameter '" + this.parameter.getId() + "' dimension");
        }
        this.maskParameter = parameter;
        parameter.addParameterListener(this);
        this.equalValue = bl ? 1 : 0;
        this.updateMask();
    }

    private void updateMask() {
        this.length = MaskedParameter.updateMask(this.maskParameter, this.map, this.inverseMap, this.equalValue);
        this.bounds = null;
    }

    public static int updateMask(Parameter parameter, int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        for (int i = 0; i < parameter.getDimension(); ++i) {
            int n3 = (int)parameter.getParameterValue(i);
            if (n3 == n) {
                nArray[n2] = i;
                nArray2[i] = n2++;
                continue;
            }
            nArray2[i] = -1;
        }
        return n2;
    }

    @Override
    public int getDimension() {
        return this.length;
    }

    @Override
    protected void storeValues() {
        this.parameter.storeParameterValues();
        this.maskParameter.storeParameterValues();
        System.arraycopy(this.map, 0, this.storedMap, 0, this.map.length);
        System.arraycopy(this.inverseMap, 0, this.storedInverseMap, 0, this.inverseMap.length);
    }

    @Override
    protected void restoreValues() {
        this.parameter.restoreParameterValues();
        this.maskParameter.restoreParameterValues();
        int[] nArray = this.storedMap;
        this.storedMap = this.map;
        this.map = nArray;
        nArray = this.storedInverseMap;
        this.storedInverseMap = this.inverseMap;
        this.inverseMap = nArray;
    }

    @Override
    public void fireParameterChangedEvent() {
        if (this.signaling == Signaling.NORMAL) {
            this.doNotPropagateChangeUp = true;
            this.parameter.fireParameterChangedEvent();
            this.doNotPropagateChangeUp = false;
        }
        super.fireParameterChangedEvent();
    }

    @Override
    public void fireParameterChangedEvent(int n, Variable.ChangeType changeType) {
        if (this.signaling == Signaling.NORMAL) {
            this.doNotPropagateChangeUp = true;
            this.parameter.fireParameterChangedEvent(n, changeType);
            this.doNotPropagateChangeUp = false;
        }
        super.fireParameterChangedEvent(n, changeType);
    }

    @Override
    protected void acceptValues() {
        this.parameter.acceptParameterValues();
        this.maskParameter.acceptParameterValues();
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        throw new IllegalArgumentException("Not yet implemented");
    }

    @Override
    public double getParameterValue(int n) {
        return this.parameter.getParameterValue(this.map[n]);
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.parameter.setParameterValue(this.map[n], d);
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.parameter.setParameterValueQuietly(this.map[n], d);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.parameter.setParameterValueNotifyChangedAll(this.map[n], d);
    }

    public double getParameterMaskValue(int n) {
        return this.maskParameter.getParameterValue(n);
    }

    @Override
    public String getParameterName() {
        if (this.getId() == null) {
            return "masked." + this.parameter.getParameterName();
        }
        return this.getId();
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        int n = this.parameter.getDimension();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        Arrays.fill(dArray, Double.NEGATIVE_INFINITY);
        Arrays.fill(dArray2, Double.POSITIVE_INFINITY);
        assert (bounds.getBoundsDimension() == this.getDimension());
        int n2 = this.getDimension();
        for (int i = 0; i < n2; ++i) {
            dArray[this.map[i]] = bounds.getLowerLimit(i);
            dArray2[this.map[i]] = bounds.getUpperLimit(i);
        }
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(dArray2, dArray);
        this.parameter.addBounds(defaultBounds);
    }

    @Override
    public Bounds<Double> getBounds() {
        Bounds<Double> bounds;
        if (this.bounds == null && (bounds = this.parameter.getBounds()) != null) {
            double[] dArray = new double[this.length];
            double[] dArray2 = new double[this.length];
            for (int i = 0; i < this.length; ++i) {
                dArray[i] = bounds.getUpperLimit(this.map[i]);
                dArray2[i] = bounds.getLowerLimit(this.map[i]);
            }
            this.bounds = new Parameter.DefaultBounds(dArray, dArray2);
        }
        return this.bounds;
    }

    public Parameter getUnmaskedParameter() {
        return this.parameter;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.maskParameter) {
            this.updateMask();
            super.fireParameterChangedEvent();
        } else if (variable == this.parameter) {
            if (!this.doNotPropagateChangeUp) {
                if (n == -1) {
                    super.fireParameterChangedEvent();
                } else if (this.inverseMap[n] != -1) {
                    super.fireParameterChangedEvent(this.inverseMap[n], changeType);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown variable");
        }
    }

    public static enum Signaling {
        NORMAL,
        NO_DEPENDENT;

    }
}

