/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase;

import dr.evolution.util.Date;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.AbstractOutbreak;
import dr.evomodel.epidemiology.casetocase.SpatialKernel;
import dr.evomodel.epidemiology.casetocase.periodpriors.AbstractPeriodPriorDistribution;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.ProductStatistic;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class CategoryOutbreak
extends AbstractOutbreak {
    public static final String CATEGORY_OUTBREAK = "categoryOutbreak";
    private final HashSet<String> latentCategories;
    private final HashSet<String> infectiousCategories;
    private final HashMap<String, Parameter> latentMap;
    private final HashMap<String, AbstractPeriodPriorDistribution> infectiousMap;
    private final HashMap<AbstractCase, Double> weightMap;
    private double[][] distances;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String HAS_GEOGRAPHY = "hasGeography";
        public static final String HAS_LATENT_PERIODS = "hasLatentPeriods";
        public static final String INFECTIOUS_PERIOD_PRIOR = "infectiousPeriodPrior";
        public static final String LATENT_PERIODS = "latentPeriods";
        public static final String DISTANCE_MATRIX = "distanceMatrix";
        public static final String CASE_ID = "hostID";
        public static final String END_TIME = "endTime";
        public static final String COORDINATES = "spatialCoordinates";
        public static final String INFECTION_TIME_BRANCH_POSITION = "infectionTimeBranchPosition";
        public static final String LATENT_CATEGORY = "latentCategory";
        public static final String INFECTIOUS_CATEGORY = "infectiousCategory";
        public static final String WAS_EVER_INFECTED = "wasEverInfected";
        public static final String INDEX_PRIOR_WEIGHT = "indexPriorWeight";
        private final XMLSyntaxRule[] caseRules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("wasEverInfected"), new StringAttributeRule("hostID", "The unique identifier for this host"), new StringAttributeRule("endTime", "The time of noninfectiousness of this host", true), new ElementRule(Taxon.class, 0, Integer.MAX_VALUE), new ElementRule("infectionTimeBranchPosition", Parameter.class, "The exact position on the branch along which the infection of this case occurs that it actually does occur", true), new ElementRule("spatialCoordinates", Parameter.class, "The spatial coordinates of this case", true), new StringAttributeRule("latentCategory", "The category of latent period", true), new StringAttributeRule("infectiousCategory", "The category of infectious period", true), new StringAttributeRule("indexPriorWeight", "The weight of this case in the prior probabilty for theindex case", true)};
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("hasLatentPeriods", "Whether to include a latent period in the model"), new ElementRule(ProductStatistic.class, 0, 2), new ElementRule("categoryCase", this.caseRules, 1, Integer.MAX_VALUE), new ElementRule(Taxa.class), new ElementRule("infectiousPeriodPrior", AbstractPeriodPriorDistribution.class, "A prior distribution for the length of infectious periods", 1, Integer.MAX_VALUE), new ElementRule("latentPeriods", Parameter.class, "A prior distribution for the length of latent periods", 0, Integer.MAX_VALUE), AttributeRule.newBooleanRule("hasGeography", true), new ElementRule("distanceMatrix", Parameter.class, "A matrix of distances between the cases in this outbreak", true)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = xMLObject.hasAttribute(HAS_GEOGRAPHY) && xMLObject.getBooleanAttribute(HAS_GEOGRAPHY);
            boolean bl2 = Boolean.parseBoolean((String)xMLObject.getAttribute(HAS_LATENT_PERIODS));
            Taxa taxa = (Taxa)xMLObject.getChild(Taxa.class);
            HashMap<String, AbstractPeriodPriorDistribution> hashMap = new HashMap<String, AbstractPeriodPriorDistribution>();
            HashMap<String, Parameter> hashMap2 = new HashMap<String, Parameter>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Object object2 = xMLObject.getChild(i);
                if (!(object2 instanceof XMLObject)) continue;
                if (((XMLObject)object2).getName().equals(INFECTIOUS_PERIOD_PRIOR)) {
                    AbstractPeriodPriorDistribution n = (AbstractPeriodPriorDistribution)((XMLObject)object2).getChild(AbstractPeriodPriorDistribution.class);
                    hashMap.put(n.getModelName(), n);
                    continue;
                }
                if (!((XMLObject)object2).getName().equals(LATENT_PERIODS)) continue;
                Parameter parameter = (Parameter)((XMLObject)object2).getChild(Parameter.class);
                hashMap2.put(parameter.getParameterName(), parameter);
            }
            CategoryOutbreak categoryOutbreak = new CategoryOutbreak(null, taxa, bl, bl2, hashMap, hashMap2);
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Object object = xMLObject.getChild(i);
                if (!(object instanceof XMLObject) || !((XMLObject)object).getName().equals("categoryCase")) continue;
                this.parseCase((XMLObject)object, categoryOutbreak, bl2);
            }
            if (xMLObject.hasChildNamed(DISTANCE_MATRIX)) {
                if (!bl) {
                    throw new XMLParseException("Told there is no geography but given a distance matrix");
                }
                Parameter parameter = (Parameter)xMLObject.getElementFirstChild(DISTANCE_MATRIX);
                int n = categoryOutbreak.size();
                if (parameter.getDimension() != n * n) {
                    throw new XMLParseException("Wrong number of distance matrix entries");
                }
                double[][] dArray = new double[n][n];
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n; ++j) {
                        dArray[i][j] = i == j ? 0.0 : parameter.getParameterValue(n2);
                        ++n2;
                    }
                }
                categoryOutbreak.setDistanceMatrix(dArray);
            } else if (bl) {
                for (AbstractCase abstractCase : categoryOutbreak.getCases()) {
                    if (abstractCase.getCoords() != null) continue;
                    throw new XMLParseException("Some cases have no geographical information");
                }
                categoryOutbreak.buildDistanceMatrix();
            }
            return categoryOutbreak;
        }

        public void parseCase(XMLObject xMLObject, CategoryOutbreak categoryOutbreak, boolean bl) throws XMLParseException {
            String string = (String)xMLObject.getAttribute(CASE_ID);
            Parameter parameter = xMLObject.hasChildNamed(COORDINATES) ? (Parameter)xMLObject.getElementFirstChild(COORDINATES) : null;
            boolean bl2 = xMLObject.getBooleanAttribute(WAS_EVER_INFECTED);
            if (bl2) {
                if (!(xMLObject.hasAttribute(INFECTIOUS_CATEGORY) && xMLObject.hasAttribute(END_TIME) && xMLObject.hasChildNamed(INFECTION_TIME_BRANCH_POSITION))) {
                    throw new XMLParseException("Case " + string + " wasEverInfected but lacks infection-related data");
                }
                String string2 = (String)xMLObject.getAttribute(INFECTIOUS_CATEGORY);
                double d = Double.parseDouble((String)xMLObject.getAttribute(END_TIME));
                String string3 = null;
                if (xMLObject.hasAttribute(LATENT_CATEGORY)) {
                    string3 = (String)xMLObject.getAttribute(LATENT_CATEGORY);
                } else if (bl) {
                    throw new XMLParseException("Case " + string + " not assigned a latent periods distribution");
                }
                double d2 = 1.0;
                if (xMLObject.hasAttribute(INDEX_PRIOR_WEIGHT)) {
                    d2 = Double.parseDouble((String)xMLObject.getAttribute(INDEX_PRIOR_WEIGHT));
                }
                Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(INFECTION_TIME_BRANCH_POSITION);
                Taxa taxa = new Taxa();
                for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                    if (!(xMLObject.getChild(i) instanceof Taxon)) continue;
                    taxa.addTaxon((Taxon)xMLObject.getChild(i));
                }
                categoryOutbreak.addCase(string, d, parameter, parameter2, taxa, d2, string2, string3);
            } else {
                categoryOutbreak.addNoninfectedCase(string, parameter);
            }
        }

        @Override
        public String getParserDescription() {
            return "Parses a set of 'category' farm outbreak and the information that they all share";
        }

        @Override
        public Class getReturnType() {
            return CategoryOutbreak.class;
        }

        @Override
        public String getParserName() {
            return CategoryOutbreak.CATEGORY_OUTBREAK;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public CategoryOutbreak(String string, Taxa taxa, boolean bl, boolean bl2, HashMap<String, AbstractPeriodPriorDistribution> hashMap, HashMap<String, Parameter> hashMap2) {
        super(string, taxa, bl2, bl);
        this.cases = new ArrayList();
        this.latentCategories = new HashSet();
        this.infectiousCategories = new HashSet();
        this.latentMap = hashMap2;
        this.infectiousMap = hashMap;
        for (AbstractPeriodPriorDistribution loggable : hashMap.values()) {
            this.addModel(loggable);
        }
        for (Parameter parameter : hashMap2.values()) {
            this.addVariable(parameter);
        }
        this.weightMap = new HashMap();
    }

    private void addCase(String string, double d, Parameter parameter, Parameter parameter2, Taxa taxa, double d2, String string2, String string3) {
        CategoryCase categoryCase;
        if (string3 == null) {
            categoryCase = new CategoryCase(string, d, parameter, parameter2, taxa, d2, string2);
        } else {
            categoryCase = new CategoryCase(string, d, parameter, parameter2, taxa, d2, string2, string3);
            this.latentCategories.add(string3);
        }
        this.weightMap.put(categoryCase, d2);
        this.infectiousCategories.add(string2);
        this.cases.add(categoryCase);
        ++this.infectedSize;
        this.addModel(categoryCase);
    }

    private void addNoninfectedCase(String string, Parameter parameter) {
        CategoryCase categoryCase = new CategoryCase(string, Double.POSITIVE_INFINITY, parameter, null, null, 0.0, null);
        categoryCase.setEverInfected(false);
        this.cases.add(categoryCase);
        this.addModel(categoryCase);
    }

    public HashMap<AbstractCase, Double> getWeightMap() {
        return this.weightMap;
    }

    public HashSet<String> getLatentCategories() {
        return this.latentCategories;
    }

    public HashSet<String> getInfectiousCategories() {
        return this.infectiousCategories;
    }

    public int getLatentCategoryCount() {
        return this.latentCategories.size();
    }

    public int getInfectiousCategoryCount() {
        return this.infectiousCategories.size();
    }

    public HashMap<String, Parameter> getLatentMap() {
        return this.latentMap;
    }

    public HashMap<String, AbstractPeriodPriorDistribution> getInfectiousMap() {
        return this.infectiousMap;
    }

    public Parameter getLatentPeriod(String string) {
        return this.latentMap.get(string);
    }

    public AbstractPeriodPriorDistribution getInfectiousCategoryPrior(String string) {
        return this.infectiousMap.get(string);
    }

    public String getInfectiousCategory(AbstractCase abstractCase) {
        return ((CategoryCase)abstractCase).getInfectiousCategory();
    }

    public String getLatentCategory(AbstractCase abstractCase) {
        return ((CategoryCase)abstractCase).getLatentCategory();
    }

    @Override
    public double getLatentPeriod(AbstractCase abstractCase) {
        return this.latentMap.get(((CategoryCase)abstractCase).getLatentCategory()).getParameterValue(0);
    }

    @Override
    public double getDistance(AbstractCase abstractCase, AbstractCase abstractCase2) {
        if (this.distances == null) {
            throw new RuntimeException("Distance matrix has not been initialised");
        }
        return this.distances[this.getCaseIndex(abstractCase)][this.getCaseIndex(abstractCase2)];
    }

    private void setDistanceMatrix(double[][] dArray) {
        this.distances = dArray;
    }

    private void buildDistanceMatrix() {
        this.distances = new double[this.cases.size()][this.cases.size()];
        if (this.hasGeography) {
            for (int i = 0; i < this.cases.size(); ++i) {
                for (int j = 0; j < this.cases.size(); ++j) {
                    this.distances[i][j] = SpatialKernel.EuclideanDistance(this.getCase(i).getCoords(), this.getCase(j).getCoords());
                }
            }
        }
    }

    @Override
    public int getPatternIndex(int n) {
        return -1;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (!(model instanceof AbstractPeriodPriorDistribution)) {
            this.fireModelChanged(object);
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    private class CategoryCase
    extends AbstractCase {
        public static final String CATEGORY_CASE = "categoryCase";
        private String infectiousCategory;
        private String latentCategory;
        private Parameter coords;
        private double indexPriorWeight;
        private final ArrayList<Date> examinationTimes;

        private CategoryCase(String string, String string2, double d, Parameter parameter, Parameter parameter2, Taxa taxa, double d2, String string3, String string4) {
            super(string);
            this.wasEverInfected = taxa != null;
            this.caseID = string2;
            this.infectiousCategory = string3;
            this.infectionBranchPosition = parameter2;
            if (parameter2 != null) {
                this.addVariable(parameter2);
            }
            this.endOfInfectiousTime = d;
            this.associatedTaxa = taxa;
            this.coords = parameter;
            this.indexPriorWeight = d2;
            this.latentCategory = string4;
            this.examinationTimes = new ArrayList();
            if (this.wasEverInfected) {
                for (Taxon taxon : taxa) {
                    this.examinationTimes.add(taxon.getDate());
                }
            }
        }

        private CategoryCase(String string, String string2, double d, Parameter parameter, Parameter parameter2, Taxa taxa, String string3) {
            this(string, string2, d, parameter, parameter2, taxa, 1.0, string3, null);
        }

        private CategoryCase(String string, double d, Parameter parameter, Parameter parameter2, Taxa taxa, double d2, String string2) {
            this(CATEGORY_CASE, string, d, parameter, parameter2, taxa, d2, string2, null);
        }

        private CategoryCase(String string, double d, Parameter parameter, Parameter parameter2, Taxa taxa, double d2, String string2, String string3) {
            this(CATEGORY_CASE, string, d, parameter, parameter2, taxa, d2, string2, string3);
        }

        public String getLatentCategory() {
            return this.latentCategory;
        }

        public String getInfectiousCategory() {
            return this.infectiousCategory;
        }

        public double getIndexPriorWeight() {
            return this.indexPriorWeight;
        }

        @Override
        public boolean noninfectiousYet(double d) {
            return d > this.endOfInfectiousTime;
        }

        @Override
        public ArrayList<Date> getExaminationTimes() {
            return this.examinationTimes;
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
            this.fireModelChanged();
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            this.fireModelChanged(this);
        }

        @Override
        protected void storeState() {
        }

        @Override
        protected void restoreState() {
        }

        @Override
        protected void acceptState() {
        }

        @Override
        public double[] getCoords() {
            return new double[]{this.coords.getParameterValue(0), this.coords.getParameterValue(1)};
        }
    }
}

