/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel.lineagespecific;

import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import java.util.LinkedList;

public class CountableRealizationsParameter
extends Parameter.Abstract
implements VariableListener {
    private final Parameter categoriesParameter;
    private final CompoundParameter uniquelyRealizedParameters;
    private final int dim;
    private final int realizationCount;
    private final int uniqueRealizationCount;
    private final LinkedList<Parameter> paramList;
    private Bounds<Double> bounds = null;

    public CountableRealizationsParameter(Parameter parameter, CompoundParameter compoundParameter) {
        this.categoriesParameter = parameter;
        this.uniquelyRealizedParameters = compoundParameter;
        this.dim = compoundParameter.getParameter(0).getDimension();
        this.realizationCount = parameter.getDimension();
        this.paramList = new LinkedList();
        this.paramList.add(parameter);
        this.paramList.add(compoundParameter);
        this.uniqueRealizationCount = compoundParameter.getDimension();
    }

    @Override
    public int getDimension() {
        return this.dim * this.realizationCount;
    }

    @Override
    protected void storeValues() {
        for (Parameter parameter : this.paramList) {
            parameter.storeParameterValues();
        }
    }

    @Override
    protected void restoreValues() {
        for (Parameter parameter : this.paramList) {
            parameter.restoreParameterValues();
        }
    }

    @Override
    protected void acceptValues() {
        for (Parameter parameter : this.paramList) {
            parameter.acceptParameterValues();
        }
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getParameterValue(int n) {
        int n2 = ((Double)this.categoriesParameter.getValue(n)).intValue();
        int n3 = 0;
        Parameter parameter = this.uniquelyRealizedParameters.getParameter(n2);
        return parameter.getParameterValue(n3);
    }

    public double[] getAllParameterValues(int n) {
        int n2 = ((Double)this.categoriesParameter.getValue(n)).intValue();
        Parameter parameter = this.uniquelyRealizedParameters.getParameter(n2);
        double[] dArray = new double[parameter.getSize()];
        for (int i = 0; i < parameter.getSize(); ++i) {
            dArray[i] = parameter.getParameterValue(i);
        }
        return dArray;
    }

    @Override
    public void setParameterValue(int n, double d) {
        int n2 = (int)this.categoriesParameter.getParameterValue(n);
        this.uniquelyRealizedParameters.setParameterValue(n2, d);
    }

    public void setParameterValue(int n, double[] dArray) {
        int n2 = (int)this.categoriesParameter.getParameterValue(n);
        if (this.uniquelyRealizedParameters.getParameter(n2).getSize() != dArray.length) {
            throw new RuntimeException("parameter and array with parameter values must have same dimension");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.uniquelyRealizedParameters.getParameter(n2).setParameterValue(i, dArray[i]);
        }
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String getParameterName() {
        if (this.getId() == null) {
            StringBuilder stringBuilder = new StringBuilder("product");
            for (Parameter parameter : this.paramList) {
                stringBuilder.append(".").append(parameter.getId());
            }
            this.setId(stringBuilder.toString());
        }
        return this.getId();
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        this.bounds = bounds;
    }

    @Override
    public Bounds<Double> getBounds() {
        if (this.bounds == null) {
            return this.paramList.get(0).getBounds();
        }
        return this.bounds;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireParameterChangedEvent(n, changeType);
    }
}

