/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.operators;

import dr.evomodel.arg.ARGModel;
import dr.inference.model.CompoundParameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class ARGReassortmentOperator
extends SimpleMCMCOperator {
    public static final String ADD_PROBABILITY = "addProbability";
    public static final String ARG_REASSORTMENT_OPERATOR = "argReassortmentOperator";
    public static final String INTERNAL_NODES = "internalNodes";
    public static final String INTERNAL_AND_ROOT = "internalNodesPlusRoot";
    public static final String NODE_RATES = "nodeRates";
    public static final String CHOOSE_BRANCHES_FIRST = "chooseBranchesFirst";
    public static final double LOG_TWO = Math.log(2.0);
    private double singlePartitionProbability = 0.0;
    private double probBelowRoot = 0.9;
    private double size = 0.0;
    private boolean branchesFirst;
    private ARGModel arg;
    private CompoundParameter internalNodeParameters;
    private CompoundParameter internalAndRootNodeParameters;
    private CompoundParameter nodeRates;

    public ARGReassortmentOperator(ARGModel aRGModel, int n, boolean bl, double d, double d2, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3) {
        this.arg = aRGModel;
        this.internalNodeParameters = compoundParameter;
        this.internalAndRootNodeParameters = compoundParameter2;
        this.nodeRates = compoundParameter3;
        this.branchesFirst = bl;
        this.singlePartitionProbability = d;
        this.setWeight(n);
        this.size = d2;
        this.probBelowRoot = -Math.log(1.0 - Math.sqrt(this.probBelowRoot));
    }

    @Override
    public double doOperation() {
        double d = 0.0;
        d = MathUtils.nextDouble() < 1.0 / (1.0 + Math.exp(-this.size)) ? this.addOperation() - this.size : this.removeOperation() + this.size;
        return d;
    }

    private double addOperation() {
        if (this.branchesFirst) {
            return this.addOperationBranchesFirst();
        }
        return this.addOperationHeightsFirst();
    }

    private double addOperationBranchesFirst() {
        double d = 0.0;
        double d2 = this.arg.getNodeHeight(this.arg.getRoot());
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = this.probBelowRoot / d2;
        while (d3 > d2 && d4 > d2) {
            d3 = MathUtils.nextExponential(d5);
            d4 = MathUtils.nextExponential(d5);
        }
        d += d5 * (d3 + d4) - LOG_TWO - 2.0 * Math.log(d5) + Math.log(1.0 - Math.exp(-2.0 * d2 * d5));
        if (d3 < d4) {
            double d6 = d3;
            d3 = d4;
            d4 = d6;
        }
        return 0.0;
    }

    private double addOperationHeightsFirst() {
        return 0.0;
    }

    private double removeOperation() {
        return 0.0;
    }

    @Override
    public String getOperatorName() {
        return ARG_REASSORTMENT_OPERATOR;
    }

    public String getPerformanceSuggestion() {
        return "Try changing the add probability probability";
    }

    private class NoReassortmentEventException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoReassortmentEventException() {
            super("");
        }
    }
}

