## ----app, eval=FALSE----------------------------------------------------------
# # load libraries
# library(teal.modules.general)
# library(teal.widgets)
# library(sparkline)
# 
# # teal_data object
# data <- teal_data()
# data <- within(data, {
#   ADSL <- teal.data::rADSL
#   ADTTE <- teal.data::rADTTE
# })
# join_keys(data) <- default_cdisc_join_keys[names(data)]
# 
# # tm_variable_browser module
# tm_variable_browser_module <- tm_variable_browser(
#   label = "Variable browser",
#   ggplot2_args = ggplot2_args(
#     labs = list(subtitle = "Plot generated by Variable Browser Module")
#   )
# )
# 
# # initialize the app
# app <- init(
#   data = data,
#   modules = modules(tm_variable_browser_module)
# )
# 
# shinyApp(app$ui, app$server)

## ----shinylive_url, echo = FALSE, results = 'asis'----------------------------
code <- paste0(c(
  knitr::knit_code$get("app")
), collapse = "\n")

url <- roxy.shinylive::create_shinylive_url(code)
cat(sprintf("[Open in Shinylive](%s)\n\n", url))

## ----shinylive_iframe, echo = FALSE, out.width = '150%', out.extra = 'style = "position: relative; z-index:1"', eval = requireNamespace("roxy.shinylive", quietly = TRUE) && knitr::is_html_output() && identical(Sys.getenv("IN_PKGDOWN"), "true")----
# knitr::include_url(url, height = "800px")

## ----warning=FALSE, message=FALSE---------------------------------------------
library(teal.modules.general)
library(teal.widgets)

## ----warning=FALSE, message=FALSE---------------------------------------------
data <- teal_data()
data <- within(data, {
  ADSL <- teal.data::rADSL
  ADTTE <- teal.data::rADTTE
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

## ----warning=FALSE, message=FALSE---------------------------------------------
tm_variable_browser_module <- tm_variable_browser(
  # module name to display in the GUI
  label = "Variable browser",
  # this argument takes a set of arguments to pass to ggplot2.
  # the arguments must have the same names as its ggplot2 counterpart, e.g. `subtitle`
  ggplot2_args = ggplot2_args(
    labs = list(subtitle = "Plot generated by Variable Browser Module")
  )
)

app <- init(
  data = data,
  modules = modules(tm_variable_browser_module)
)

if (interactive()) {
  shinyApp(app$ui, app$server)
}

## ----indent = "     ", eval = requireNamespace("sparkline", quietly = TRUE)----
class(app)
names(app)

