/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.HashSet;
import java.util.Set;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.visitors.DeepFieldResolver;
import org.jpmml.converter.visitors.DeepFieldResolverUtil;
import org.jpmml.model.visitors.FieldResolver;

public abstract class ActiveFieldFinder
extends DeepFieldResolver {
    private Set<Field<?>> activeFields = new HashSet();

    @Override
    public void reset() {
        super.reset();
        this.activeFields.clear();
    }

    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof MiningModel) {
            MiningModel miningModel = (MiningModel)parent;
            this.processMiningModel(miningModel);
        } else if (parent instanceof Model) {
            Model model = (Model)parent;
            this.processModel(model);
        }
        return parent;
    }

    private void processMiningModel(MiningModel miningModel) {
        Set<Field<?>> activeFields = this.getActiveFields();
        activeFields.addAll(DeepFieldResolverUtil.getActiveFields((FieldResolver)this, miningModel));
    }

    private void processModel(Model model) {
        Set<Field<?>> activeFields = this.getActiveFields();
        activeFields.addAll(DeepFieldResolverUtil.getActiveFields((FieldResolver)this, model));
    }

    public Set<Field<?>> getActiveFields() {
        return this.activeFields;
    }
}

