## ----echo=FALSE, include=FALSE------------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_narrow_square)
opts_knit$set(concordance=TRUE)
opts_knit$set(unnamed.chunk.label = 'functions-chunk')
rm(plot)


## ----stat-fun-1---------------------------------------------------------------------------------------------------------
x <- c(1:20, NA)
mean(x)
mean(x, na.rm = TRUE)


## ----stat-fun-2---------------------------------------------------------------------------------------------------------
x <- c(1:20, 100)
mean(x)
mean(x, trim = 0.05)


## ----distrib-01---------------------------------------------------------------------------------------------------------
dnorm(x = 1.5, mean = 1, sd = 0.5)


## ----distrib-01a--------------------------------------------------------------------------------------------------------
dnorm(x = seq(from = -1, to = 1, length.out = 5), mean = 1, sd = 0.5)


## ----distrib-01b--------------------------------------------------------------------------------------------------------
vct1 <- seq(from = -1, to = 3, length.out = 50)

df1 <- data.frame(x = vct1,
                  y = dnorm(x = vct1, mean = 1, sd = 1))
plot(y~x, data = df1, type = "l", xlab = "z", ylab = "f(z)")
points(x = 2, y = dnorm(x = 2, mean = 1, sd = 1))


## ----distrib-02---------------------------------------------------------------------------------------------------------
pnorm(q = 2, mean = 1, sd = 1)
pnorm(q = 2, mean = 1, sd = 1, lower.tail = FALSE)
pnorm(q = 2, mean = 1, sd = 4, lower.tail = FALSE)
pnorm(q = c(2, 4), mean = 1, sd = 1, lower.tail = FALSE)


## ----distrib-03---------------------------------------------------------------------------------------------------------
qnorm(p = 0.01, mean = 0, sd = 1)
qnorm(p = 0.05, mean = 0, sd = 1)
qnorm(p = 0.05, mean = 0, sd = 1, lower.tail = FALSE)


## ----distrib-WB01-------------------------------------------------------------------------------------------------------
qnorm(p = 0.025, mean = 0, sd = 1)
qnorm(p = 0.025, mean = 0, sd = 1, lower.tail = FALSE)


## ----distrib-WB02-------------------------------------------------------------------------------------------------------
pnorm(q = 4, mean = 0, sd = 1) * 2


## ----distrib-04,echo=2:3------------------------------------------------------------------------------------------------
set.seed(12234)
rnorm(5)
rnorm(n = 10, mean = 10, sd = 2)


## ----density-01---------------------------------------------------------------------------------------------------------
d <- density(faithful$waiting, bw = "sj")


## ----density-02---------------------------------------------------------------------------------------------------------
str(d)


## ----density-03---------------------------------------------------------------------------------------------------------
d$n


## ----desnity-04---------------------------------------------------------------------------------------------------------
plot(d)


## ----sampling-01--------------------------------------------------------------------------------------------------------
sample(x = LETTERS)
sample(x = LETTERS, size = 12)
sample(x = LETTERS, size = 12, replace = TRUE)


## ----sampling-02--------------------------------------------------------------------------------------------------------
cars[sample(x = 1:nrow(cars), size = 4), ]


## ----sampling-03, eval=eval_playground----------------------------------------------------------------------------------
cars[sample(x = nrow(cars), size = 4), ]


## ----cor-01-------------------------------------------------------------------------------------------------------------
cor(x = cars$speed, y = cars$dist)


## ----cor-02-------------------------------------------------------------------------------------------------------------
cor(cars)


## ----cor-02a------------------------------------------------------------------------------------------------------------
mat1 <- matrix(rnorm(54), ncol = 3,
               dimnames = list(rows = 1:18, cols = c("A", "B", "C")))
cor(mat1)


## ----cor-03-------------------------------------------------------------------------------------------------------------
cor.test(x = cars$speed, y = cars$dist)


## ----cor-03a, eval=eval_playground--------------------------------------------------------------------------------------
cor.test(formula = ~ speed + dist, data = cars)


## ----cor-PG01, eval=eval_playground-------------------------------------------------------------------------------------
MAT1 <- cor(cars)
class(MAT1)
attributes(MAT1)
str(MAT1)


## ----cor-04-------------------------------------------------------------------------------------------------------------
cor(x = cars$speed, y = cars$dist, method = "kendall")
cor(x = cars$speed, y = cars$dist, method = "spearman")


## ----ttest-01-----------------------------------------------------------------------------------------------------------
df1 <- data.frame(some.size = c(rnorm(10, mean = 2.5), rnorm(10, mean = 2.0)),
                  group = factor(rep(c("A", "B"), each = 10)))


## ----ttest-02-----------------------------------------------------------------------------------------------------------
t.test(some.size ~ 1, mu = 2, data = df1)


## ----ttest-02a----------------------------------------------------------------------------------------------------------
sem = sqrt(var(df1$some.size) / nrow(df1))
t.value = (mean(df1$some.size) - 2) / sem # Ho: mu = 2
p.value <- pt(t.value, df = nrow(df1) - 1, lower.tail = FALSE) * 2 # two tails
signif(c(t = t.value, df = nrow(df1) - 1, P = p.value), 4) # 4 digits


## ----ttest-03-----------------------------------------------------------------------------------------------------------
t.test(some.size ~ group, data = df1)


## ----ttest-03a----------------------------------------------------------------------------------------------------------
t.test(some.size ~ group, var.equal = TRUE, data = df1)


## ----models-1-----------------------------------------------------------------------------------------------------------
fm1 <- lm(dist ~ 1 + speed, data=cars)
class(fm1)


## ----models-1a----------------------------------------------------------------------------------------------------------
plot(fm1, which = 2)


## ----models-1b----------------------------------------------------------------------------------------------------------
summary(fm1)


## ----models-2-----------------------------------------------------------------------------------------------------------
fm2 <- lm(dist ~ speed - 1, data = cars)
summary(fm2)


## ----models-3, eval=eval_playground-------------------------------------------------------------------------------------
fm3 <- lm(dist ~ speed + I(speed^2), data = cars)
plot(fm3, which = 3)
summary(fm3)


## ----models-3a, eval=eval_playground------------------------------------------------------------------------------------
fm3a <- lm(dist ~ poly(speed, 2), data = cars)
summary(fm3a)


## ----models-4, eval=eval_playground-------------------------------------------------------------------------------------
anova(fm2, fm1)


## ----models-5, eval=eval_playground-------------------------------------------------------------------------------------
anova(fm2, fm3, fm3a)
anova(fm2, fm3a, fm3)


## ----models-5a, eval=eval_playground------------------------------------------------------------------------------------
BIC(fm2, fm1, fm3, fm3a)
AIC(fm2, fm1, fm3, fm3a)


## ----models-EB2ca-------------------------------------------------------------------------------------------------------
class(summary(fm1))


## ----models-EB3---------------------------------------------------------------------------------------------------------
str(summary(fm1), no.list = TRUE, give.attr = FALSE, vec.len = 2)


## ----models-EB4---------------------------------------------------------------------------------------------------------
summary(fm1)$adj.r.squared


## ----models-EB3b--------------------------------------------------------------------------------------------------------
coef(fm1)
str(fm1$coefficients)
print(summary(fm1)$coefficients)
str(summary(fm1)$coefficients)


## ----models-EB2---------------------------------------------------------------------------------------------------------
anova(fm1)


## ----models-EB2a--------------------------------------------------------------------------------------------------------
class(anova(fm1))


## ----models-EB2b--------------------------------------------------------------------------------------------------------
str(anova(fm1))


## ----models-EB5---------------------------------------------------------------------------------------------------------
est.slope.value <- summary(fm1)$coefficients["speed", "Estimate"]
est.slope.se <- summary(fm1)$coefficients["speed", "Std. Error"]
degrees.of.freedom <- summary(fm1)$df[2]


## ----models-EB6---------------------------------------------------------------------------------------------------------
hyp.null <- 1
t.value <- (est.slope.value - hyp.null) / est.slope.se
p.value <- 2 * pt(q = t.value, df = degrees.of.freedom, lower.tail = FALSE)
cat("slope =", signif(est.slope.value, 3),
    "with s.e. =", signif(est.slope.se, 3),
    "\nt.value =", signif(t.value, 3),
    "and P-value =", signif(p.value, 3))


## ----models-EB0---------------------------------------------------------------------------------------------------------
class(fm1)
names(fm1)


## ----models-EB1---------------------------------------------------------------------------------------------------------
str(fm1, no.list = TRUE, give.attr = FALSE, vec.len = 2)


## ----models-EB1b--------------------------------------------------------------------------------------------------------
str(fm1$call)


## ----models-6z----------------------------------------------------------------------------------------------------------
data(InsectSprays)
is.numeric(InsectSprays$spray)
is.factor(InsectSprays$spray)
levels(InsectSprays$spray)


## ----models-6-----------------------------------------------------------------------------------------------------------
fm4 <- lm(count ~ spray, data = InsectSprays)


## ----model-6a-----------------------------------------------------------------------------------------------------------
plot(fm4, which = 2)


## ----model-6b-----------------------------------------------------------------------------------------------------------
anova(fm4)


## ----contrasts-01-------------------------------------------------------------------------------------------------------
options("contrasts")


## ----models-6c----------------------------------------------------------------------------------------------------------
fm4trea <- lm(count ~ spray, data = InsectSprays,
              contrasts = list(spray = contr.treatment))
fm4sum  <- lm(count ~ spray, data = InsectSprays,
              contrasts = list(spray = contr.sum))


## ----contrasts-02-------------------------------------------------------------------------------------------------------
contr.treatment(length(levels(InsectSprays$spray)))


## ----models-6d----------------------------------------------------------------------------------------------------------
summary(fm4trea)


## ----contrasts-03-------------------------------------------------------------------------------------------------------
contr.sum(length(levels(InsectSprays$spray)))


## ----models-6e----------------------------------------------------------------------------------------------------------
summary(fm4sum)


## ----models-update-01---------------------------------------------------------------------------------------------------
fm4 <- lm(count ~ spray, data = InsectSprays)
anova(fm4)
fm4a <- update(fm4, formula = log10(count + 1) ~ spray)
anova(fm4a)


## ----models-update-02---------------------------------------------------------------------------------------------------
fm4b <- update(fm4, subset = !spray %in% c("A", "B"))
anova(fm4b)


## ----models-update-03, eval=eval_playground-----------------------------------------------------------------------------
fm4c <- update(fm4, subset = !grepl("[AB]", spray))
anova(fm4c)
identical(fm4b, fm4c)


## ----models-step-01-----------------------------------------------------------------------------------------------------
fm3 <- lm(dist ~ speed + I(speed^2), data = cars)
fm3a <- step(fm3)


## ----models-step-01a----------------------------------------------------------------------------------------------------
summary(fm3)
summary(fm3a)


## ----models-step-02-----------------------------------------------------------------------------------------------------
fm3b <-
  step(fm3,
       scope = dist ~ speed + I(speed^2) + I(speed^3) + I(speed^4))
summary(fm3b)


## ----models-step-02a, eval=eval_playground------------------------------------------------------------------------------
fm3c <-
  step(fm3,
       scope = list(lower = dist ~ speed,
                    upper = dist ~ speed + I(speed^2) + I(speed^3) + I(speed^4)))
summary(fm3c)


## ----model-10-----------------------------------------------------------------------------------------------------------
fm10 <- glm(count ~ spray, data = InsectSprays, family = quasipoisson)


## ----model-11-----------------------------------------------------------------------------------------------------------
plot(fm10, which = 2)


## ----model-10a----------------------------------------------------------------------------------------------------------
anova(fm10, test = "F")


## ----model-12-----------------------------------------------------------------------------------------------------------
class(fm10)
summary(fm10)
head(residuals(fm10))
head(fitted(fm10))


## ----model-13-----------------------------------------------------------------------------------------------------------
class(fm10)
names(fm10)
fm10$converged
fm10$iter


## ----nls-01-------------------------------------------------------------------------------------------------------------
data(Puromycin)
names(Puromycin)


## ----nls-02-------------------------------------------------------------------------------------------------------------
fm21 <- nls(rate ~ SSmicmen(conc, Vm, K), data = Puromycin,
            subset = state == "treated")


## ----nls-03-------------------------------------------------------------------------------------------------------------
class(fm21)
summary(fm21)
residuals(fm21)
fitted(fm21)


## ----nls-04-------------------------------------------------------------------------------------------------------------
class(fm21)
names(fm21)


## ----nls-04a------------------------------------------------------------------------------------------------------------
fm21$convInfo


## ----spline-01----------------------------------------------------------------------------------------------------------
fs1 <- smooth.spline(x = cars$speed, y = cars$dist)
print(fs1)
plot(fs1, type = "l")
points(x = cars$speed, y = cars$dist)


## ----spline-02----------------------------------------------------------------------------------------------------------
floc <- loess(dist ~ speed, data = cars)
class(floc)
summary(floc)


## ----mformulas-intro-1--------------------------------------------------------------------------------------------------
class(y ~ x)
mode(y ~ x)


## ----mformulas-intro-2, eval=FALSE--------------------------------------------------------------------------------------
## my.formula <- dist ~ 1 + speed
## fm1 <- lm(my.formula, data=cars)


## ----mformulas-intro-5--------------------------------------------------------------------------------------------------
class(~ x + y)
mode(~ x + y)
is.empty.model(~ x + y)


## ----mformulas-intro-3--------------------------------------------------------------------------------------------------
class(formula())
mode(formula())
length(formula())
# is.empty.model(formula())


## ----mformulas-intro-4--------------------------------------------------------------------------------------------------
class(y ~ 0)
mode(y ~ 0)
is.empty.model(y ~ 0)
is.empty.model(y ~ 1)
is.empty.model(y ~ x)


## ----mformulas-intro-6--------------------------------------------------------------------------------------------------
length(formula())
length(y ~ 0)
length(y ~ 1)
length(y ~ x)
length(c(y ~ 1, y ~ x))
length(list(y ~ 1))
length(list(y ~ 1, y ~ x))


## ----mformulas-intro-6b-------------------------------------------------------------------------------------------------
sapply(list(y ~ 0, y ~ 1, y ~ x), length)
sapply(list(y ~ 0, y ~ 1, y ~ x), is.empty.model)


## ----mformulas-intro-7,eval=FALSE---------------------------------------------------------------------------------------
## y ~ I(x1 + x2)
## y ~ log(x1 + x2)


## ----mformulas-intro-8,eval=FALSE---------------------------------------------------------------------------------------
## y ~ x1 + x2 + x3 + x1:x2 + x1:x3 + x2:x3 + x1:x2:x3


## ----mformulas-00,eval=FALSE--------------------------------------------------------------------------------------------
## y ~ x1 * x2 * x3


## ----mformulas-01, eval=FALSE-------------------------------------------------------------------------------------------
## y ~ x1 + (x2 * x3)
## y ~ x1 + x2 + x3 + x2:x3


## ----mformulas-02,eval=FALSE--------------------------------------------------------------------------------------------
## y ~ x1 * (x2 + x3)
## y ~ x1 + x2 + x3 + x1:x2 + x1:x3


## ----mformulas-03,eval=FALSE--------------------------------------------------------------------------------------------
## y ~ (x1 + x2 + x3)^2
## y ~ x1 + x2 + x3 + x1:x2 + x1:x3 + x2:x3


## ----mformulas-04,eval=FALSE--------------------------------------------------------------------------------------------
## y ~ x1 + x2 + x1 %in% x2


## ----mformulas-01a, eval=FALSE------------------------------------------------------------------------------------------
## terms(y ~ x1 + (x2 * x3))
## terms(y ~ x1 * (x2 + x3))
## terms(y ~ (x1 + x2 + x3)^2)
## terms(y ~ x1 + x2 + x1 %in% x2)


## ----mformulas-PG01, eval=eval_playground-------------------------------------------------------------------------------
y ~ (x1 + x2 + x3)^2
y ~ (x1 * x2 * x3)^2


## ----mformulas-PG02, eval=FALSE-----------------------------------------------------------------------------------------
## data(npk)
## anova(lm(yield ~ N * P * K, data = npk))
## anova(lm(yield ~ (N + P + K)^2, data = npk))
## anova(lm(yield ~ N + P + K + P %in% N + K %in% N, data = npk))
## anova(lm(yield ~ N + P + K + N %in% P + K %in% P, data = npk))


## ----mformulas-W01,eval=FALSE-------------------------------------------------------------------------------------------
## y ~ A + B + A:B + A:C + B:C
## y ~ A + B + C + A:B + A:C + A:B:C


## ----mformulas-W02,eval=FALSE-------------------------------------------------------------------------------------------
## y ~ A + B + C + A:B + A:C + B:C
## y ~ (A + B + C)^2
## y ~ A + B + C + B:C
## y ~ A + B * C


## ----mformulas-EB03-----------------------------------------------------------------------------------------------------
as.formula("y ~ x")


## ----mformulas-EB04-----------------------------------------------------------------------------------------------------
paste("y", "x", sep = "~") |> as.formula()


## ----mformulas-EB05-----------------------------------------------------------------------------------------------------
as.character(y ~ x)
format(y ~ x)


## ----mformulas-EB05a----------------------------------------------------------------------------------------------------
format(y ~ x) |> gsub("x", "x + z", x = _) |> as.formula()


## ----mformulas-EB06-----------------------------------------------------------------------------------------------------
my.formula <- y ~ x1 + x2
update(my.formula, . ~ . + x3)
update(my.formula, . ~ . - x1)
update(my.formula, . ~ x3)
update(my.formula, z ~ .)
update(my.formula, . + z ~ .)


## ----ts-00--------------------------------------------------------------------------------------------------------------
my.ts <- ts(1:10, start = 2019, deltat = 1/12)


## ----ts-00aa------------------------------------------------------------------------------------------------------------
print(my.ts)


## ----ts-00a-------------------------------------------------------------------------------------------------------------
mode(my.ts)
class(my.ts)
is.ts(my.ts)
str(my.ts)
attributes(my.ts)


## ----ts-04--------------------------------------------------------------------------------------------------------------
nottem.celcius <- (nottem - 32) * 5 / 9


## ----ts-03--------------------------------------------------------------------------------------------------------------
is.ts(nottem.celcius)


## ----echo=FALSE, cache=FALSE--------------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide)


## ----ts-03plot----------------------------------------------------------------------------------------------------------
plot(nottem.celcius)


## ----ts-03a, eval=eval_playground---------------------------------------------------------------------------------------
str(nottem.celcius)
attributes(nottem.celcius)


## ----echo=FALSE, cache=FALSE--------------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide_square)


## ----ts-05, fig.height=5------------------------------------------------------------------------------------------------
nottem.stl <- stl(nottem.celcius, s.window = 7)
plot(nottem.stl)


## ----ts-06--------------------------------------------------------------------------------------------------------------
class(nottem.stl)
str(nottem.stl, no.list = TRUE, give.attr = FALSE, vec.len = 2)


## ----ts-07--------------------------------------------------------------------------------------------------------------
summary(nottem.stl)


## ----echo=FALSE, cache=FALSE--------------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_narrow)


## ----ts-08--------------------------------------------------------------------------------------------------------------
acf(nottem)


## ----manova-02----------------------------------------------------------------------------------------------------------
mmf2 <- manova(cbind(Petal.Length, Petal.Width) ~  Species, data = iris)
anova(mmf2)
summary(mmf2)


## ----pca-01-------------------------------------------------------------------------------------------------------------
pc <- prcomp(iris[c("Sepal.Length", "Sepal.Width",
                    "Petal.Length", "Petal.Width")],
             center = TRUE,
             scale = TRUE)


## ----pca-02-------------------------------------------------------------------------------------------------------------
class(pc)
pc


## ----pca-03-------------------------------------------------------------------------------------------------------------
summary(pc)


## ----pca-04-------------------------------------------------------------------------------------------------------------
plot(pc)


## ----include=FALSE, cache=FALSE-----------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide_square)


## ----pca-05-------------------------------------------------------------------------------------------------------------
biplot(pc)


## ----include=FALSE, cache=FALSE-----------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_narrow)


## ----pca-EB-01, eval=eval_playground------------------------------------------------------------------------------------
class(pc)
str(pc, max.level = 1)


## ----mds-01-------------------------------------------------------------------------------------------------------------
loc <- cmdscale(eurodist)


## ----mds-02-------------------------------------------------------------------------------------------------------------
class(loc)
dim(loc)
head(loc, 8)


## ----include=FALSE, cache=FALSE-----------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide_square)


## ----mds-03-------------------------------------------------------------------------------------------------------------
x <- loc[, 1]
y <- -loc[, 2] # change sign so North is at the top
plot(x, y, type = "n", asp = 1,
     main = "cmdscale(eurodist)")
text(x, y, rownames(loc), cex = 0.6)


## ----cluster-01---------------------------------------------------------------------------------------------------------
hc <- hclust(eurodist)
print(hc)


## ----cluster-02---------------------------------------------------------------------------------------------------------
plot(hc)


## ----cluster-03---------------------------------------------------------------------------------------------------------
cutree(hc, k = 5)


## ----cluster-04---------------------------------------------------------------------------------------------------------
str(hc)


## ----eval=eval_diag, include=eval_diag, echo=eval_diag, cache=FALSE-----------------------------------------------------
## knitter_diag()
## R_diag()
## other_diag()

