/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.util.Arrays2;
import lombok.Generated;

public final class FFT {
    private static final double[] COS_ARRAY = new double[16];
    private static final double[] SIN_ARRAY = new double[16];

    public static Complex[] expand(Complex[] data) {
        int n;
        for (n = 1; n < data.length; n <<= 1) {
        }
        if (n == data.length) {
            return data;
        }
        Complex[] ndata = new Complex[n];
        System.arraycopy(data, 0, ndata, 0, data.length);
        for (int i = data.length; i < n; ++i) {
            ndata[i] = Complex.ZERO;
        }
        return ndata;
    }

    public static double[] expand(double[] data) {
        int n;
        for (n = 1; n < data.length; n <<= 1) {
        }
        if (n == data.length) {
            return data;
        }
        double[] ndata = new double[n];
        System.arraycopy(data, 0, ndata, 0, data.length);
        return ndata;
    }

    public static void backTransform(Complex[] data) {
        FFT.transform(data, true);
    }

    public static void transform(Complex[] data) {
        FFT.transform(data, false);
    }

    public static void transform(double[] rdata, double[] idata) {
        FFT.transform(rdata, idata, false);
    }

    public static void backTransform(double[] rdata, double[] idata) {
        FFT.transform(rdata, idata, true);
    }

    private static void transform(Complex[] data, boolean back) {
        int n = data.length;
        int j = 0;
        for (int i = 0; i < n; ++i) {
            int q;
            if (j > i) {
                Arrays2.swap((Object[])data, (int)i, (int)j);
            }
            for (q = n >> 1; q >= 1 && j >= q; j -= q, q >>= 1) {
            }
            j += q;
        }
        int m = 1;
        int s = 0;
        while (m < n) {
            int tm = m << 1;
            Complex wm = Complex.cart((double)COS_ARRAY[s], (double)(back ? -SIN_ARRAY[s] : SIN_ARRAY[s]));
            Complex w = Complex.ONE;
            for (int j2 = 0; j2 < m; ++j2) {
                for (int k = j2; k < n; k += tm) {
                    int l = k + m;
                    Complex t = w.times(data[l]);
                    Complex u = data[k];
                    data[k] = u.plus(t);
                    data[l] = u.minus(t);
                }
                w = w.times(wm);
            }
            m = tm;
            ++s;
        }
        if (back) {
            double v = 1.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                data[i] = data[i].times(v);
            }
        }
    }

    private static void transform(double[] rdata, double[] idata, boolean back) {
        int n = rdata.length;
        int j = 0;
        for (int i = 0; i < n; ++i) {
            int q;
            if (j > i) {
                Arrays2.swap((double[])rdata, (int)i, (int)j);
                Arrays2.swap((double[])idata, (int)i, (int)j);
            }
            for (q = n >> 1; q >= 1 && j >= q; j -= q, q >>= 1) {
            }
            j += q;
        }
        int m = 1;
        int s = 0;
        while (m < n) {
            int tm = m << 1;
            double rwm = COS_ARRAY[s];
            double iwm = back ? -SIN_ARRAY[s] : SIN_ARRAY[s];
            double rw = 1.0;
            double iw = 0.0;
            for (int j2 = 0; j2 < m; ++j2) {
                for (int k = j2; k < n; k += tm) {
                    int l = k + m;
                    double rt = rw * rdata[l] - iw * idata[l];
                    double it = rw * idata[l] + iw * rdata[l];
                    double ru = rdata[k];
                    double iu = idata[k];
                    rdata[k] = ru + rt;
                    idata[k] = iu + it;
                    rdata[l] = ru - rt;
                    idata[l] = iu - it;
                }
                double r = rw;
                double i = iw;
                rw = r * rwm - i * iwm;
                iw = r * iwm + i * rwm;
            }
            m = tm;
            ++s;
        }
        if (back) {
            double v = 1.0 / (double)n;
            int i = 0;
            while (i < n) {
                int n2 = i;
                rdata[n2] = rdata[n2] * v;
                int n3 = i++;
                idata[n3] = idata[n3] * v;
            }
        }
    }

    @Generated
    private FFT() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        double twopi = Math.PI * 2;
        double n = 2.0;
        for (int i = 0; i < 16; ++i) {
            FFT.COS_ARRAY[i] = Math.cos(twopi / n);
            FFT.SIN_ARRAY[i] = Math.sin(twopi / n);
            n *= 2.0;
        }
    }
}

