/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ScalarLabelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.TypeUtil;
import org.jpmml.model.visitors.FieldRenamer;

public class RExpEncoder
extends ModelEncoder {
    private Label label = null;
    private List<Feature> features = new ArrayList<Feature>();
    private Map<String, String> renamedFields = new LinkedHashMap<String, String>();

    public PMML encodePMML(Model model) {
        PMML pmml = super.encodePMML(model);
        Set<Map.Entry<String, String>> entries = this.renamedFields.entrySet();
        for (Map.Entry entry : entries) {
            FieldRenamer renamer = new FieldRenamer((String)entry.getKey(), (String)entry.getValue());
            renamer.applyTo((Visitable)pmml);
        }
        return pmml;
    }

    public void addFields(RExpEncoder encoder) {
        Map dataFields = encoder.getDataFields();
        Map derivedFields = encoder.getDerivedFields();
        for (String name : dataFields.keySet()) {
            DataField dataField = this.getDataField(name);
            if (dataField != null) continue;
            dataField = (DataField)dataFields.get(name);
            this.addDataField(dataField);
        }
        for (String name : derivedFields.keySet()) {
            DerivedField derivedField = this.getDerivedField(name);
            if (derivedField != null) continue;
            derivedField = (DerivedField)derivedFields.get(name);
            this.addDerivedField(derivedField);
        }
    }

    public DataField createDataField(String name, OpType opType, DataType dataType, List<?> values) {
        if (dataType == null) {
            dataType = TypeUtil.getDataType(values);
        }
        return super.createDataField(name, opType, dataType, values);
    }

    public Schema createSchema() {
        return new Schema((ModelEncoder)this, this.getLabel(), this.getFeatures());
    }

    public void setLabel(DataField dataField) {
        this.setLabel((Label)ScalarLabelUtil.createScalarLabel((DataField)dataField));
    }

    public void addFeature(Field<?> field) {
        ContinuousFeature feature;
        OpType opType = field.requireOpType();
        switch (opType) {
            case CONTINUOUS: {
                feature = new ContinuousFeature((PMMLEncoder)this, field);
                break;
            }
            case CATEGORICAL: {
                feature = new CategoricalFeature((PMMLEncoder)this, (Field)((DataField)field));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.addFeature((Feature)feature);
    }

    public void addFeature(Feature feature) {
        List<Feature> features = this.getFeatures();
        features.add(feature);
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void renameField(String name, String renamedName) {
        this.renamedFields.put(name, renamedName);
    }
}

