/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#if !(defined H5HL_FRIEND || defined H5HL_MODULE)
#error "Do not include this file outside the H5HL package!"
#endif

#ifndef H5HLpkg_H
#define H5HLpkg_H

#include "H5HLprivate.h"

#include "H5FLprivate.h" 

H5FL_EXTERN(H5HL_free_t);

H5FL_BLK_EXTERN(lheap_chunk);

#define H5HL_SIZEOF_HDR(F)                                                                                   \
    H5HL_ALIGN(H5_SIZEOF_MAGIC +                                                       \
               1 +                                                                     \
               3 +                                                                     \
               H5F_SIZEOF_SIZE(F) +                                                    \
               H5F_SIZEOF_SIZE(F) +                                                    \
               H5F_SIZEOF_ADDR(F))  

#define H5HL_FREE_NULL 1

typedef struct H5HL_free_t {
    size_t              offset; 
    size_t              size;   
    struct H5HL_free_t *prev;   
    struct H5HL_free_t *next;   
} H5HL_free_t;

typedef struct H5HL_dblk_t H5HL_dblk_t;
typedef struct H5HL_prfx_t H5HL_prfx_t;

struct H5HL_t {
    
    size_t       rc;               
    size_t       prots;            
    size_t       sizeof_size;      
    size_t       sizeof_addr;      
    bool         single_cache_obj; 
    H5HL_free_t *freelist;         

    
    H5HL_prfx_t *prfx;       
    haddr_t      prfx_addr;  
    size_t       prfx_size;  
    hsize_t      free_block; 

    
    H5HL_dblk_t *dblk;       
    haddr_t      dblk_addr;  
    size_t       dblk_size;  
    uint8_t     *dblk_image; 
};

struct H5HL_dblk_t {
    H5AC_info_t cache_info; 
                            
    H5HL_t *heap;           
};

struct H5HL_prfx_t {
    H5AC_info_t cache_info; 
                            
    H5HL_t *heap;           
};

typedef struct H5HL_cache_prfx_ud_t {
    size_t  sizeof_size; 
    size_t  sizeof_addr; 
    haddr_t prfx_addr;   
    size_t  sizeof_prfx; 
} H5HL_cache_prfx_ud_t;

H5_DLL H5HL_t *H5HL__new(size_t sizeof_size, size_t sizeof_addr, size_t prfx_size);
H5_DLL herr_t  H5HL__dest(H5HL_t *heap);
H5_DLL herr_t  H5HL__inc_rc(H5HL_t *heap);
H5_DLL herr_t  H5HL__dec_rc(H5HL_t *heap);

H5_DLL H5HL_prfx_t *H5HL__prfx_new(H5HL_t *heap);
H5_DLL herr_t       H5HL__prfx_dest(H5HL_prfx_t *prfx);

H5_DLL H5HL_dblk_t *H5HL__dblk_new(H5HL_t *heap);
H5_DLL herr_t       H5HL__dblk_dest(H5HL_dblk_t *dblk);
H5_DLL herr_t       H5HL__dblk_realloc(H5F_t *f, H5HL_t *heap, size_t new_heap_size);

#endif 
