## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
# load the package
library(caugi)

## ----define-cg----------------------------------------------------------------
cg <- caugi(
  A %-->% B %-->% C + D,
  A %-->% C,
  class = "DAG"
)
cg

## -----------------------------------------------------------------------------
cg@ptr

## -----------------------------------------------------------------------------
cg@simple

## ----error=TRUE---------------------------------------------------------------
try({
caugi(A %-->% B, B %-->% A)
})

## -----------------------------------------------------------------------------
cg@graph_class

## -----------------------------------------------------------------------------
descendants(cg, parents(cg, "C"))

## -----------------------------------------------------------------------------
parents(cg, "C")

## -----------------------------------------------------------------------------
cg_modified <- cg |>
  remove_edges(A %-->% B, B %-->% C + D) |>
  add_edges(B %-->% A, D %-->% C)
cg_modified

## -----------------------------------------------------------------------------
aid(cg, cg_modified)
shd(cg, cg_modified, normalized = TRUE)

## -----------------------------------------------------------------------------
cg@built

## ----eval=FALSE---------------------------------------------------------------
# cg@name_index_map

## -----------------------------------------------------------------------------
cg@.state

