/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Const;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import main.AlleleProbs;
import main.GenotypeValues;
import vcf.Marker;
import vcf.VcfRecBuilder;

public final class VcfWriter {
    private static final String fileformat = "##fileformat=VCFv4.2";
    private static final String afInfo = "##INFO=<ID=AF,Number=A,Type=Float,Description=\"Estimated ALT Allele Frequencies\">";
    private static final String ar2Info = "##INFO=<ID=AR2,Number=1,Type=Float,Description=\"Allelic R-Squared: estimated squared correlation between most probable REF dose and true REF dose\">";
    private static final String dr2Info = "##INFO=<ID=DR2,Number=1,Type=Float,Description=\"Dosage R-Squared: estimated squared correlation between estimated REF dose [P(RA) + 2*P(RR)] and true REF dose\">";
    private static final String impInfo = "##INFO=<ID=IMP,Number=0,Type=Flag,Description=\"Imputed marker\">";
    private static final String gtFormat = "##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">";
    private static final String dsFormat = "##FORMAT=<ID=DS,Number=A,Type=Float,Description=\"estimated ALT dose [P(RA) + P(AA)]\">";
    private static final String glFormat = "##FORMAT=<ID=GL,Number=G,Type=Float,Description=\"Log10-scaled Genotype Likelihood\">";
    private static final String gpFormat = "##FORMAT=<ID=GP,Number=G,Type=Float,Description=\"Estimated Genotype Probability\">";
    private static final String shortChromPrefix = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO";
    private static final String longChromPrefix = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";

    private VcfWriter() {
    }

    public static void writeMetaLinesGT(String[] stringArray, String string, PrintWriter printWriter) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        VcfWriter.writeMetaLines(stringArray, string, bl, bl2, bl3, printWriter);
    }

    public static void writeMetaLines(String[] stringArray, String string, boolean bl, boolean bl2, boolean bl3, PrintWriter printWriter) {
        printWriter.print(fileformat);
        printWriter.print(Const.nl);
        printWriter.print("##filedate=");
        printWriter.print(VcfWriter.now());
        printWriter.print(Const.nl);
        if (string != null) {
            printWriter.print("##source=\"");
            printWriter.print(string);
            printWriter.println("\"");
        }
        if (bl2) {
            printWriter.println(afInfo);
            printWriter.println(ar2Info);
            printWriter.println(dr2Info);
            printWriter.println(impInfo);
        }
        if (bl) {
            printWriter.println(gtFormat);
        }
        if (bl3) {
            printWriter.println(glFormat);
        }
        if (bl2) {
            printWriter.println(dsFormat);
            printWriter.println(gpFormat);
        }
        printWriter.print(longChromPrefix);
        for (String string2 : stringArray) {
            if (string2 == null) {
                throw new NullPointerException("id==null");
            }
            printWriter.print('\t');
            printWriter.print(string2);
        }
        printWriter.println();
    }

    private static String now() {
        String string = "yyyyMMdd";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static void appendRecords(GenotypeValues genotypeValues, int n, int n2, PrintWriter printWriter) {
        if (n > n2) {
            throw new IllegalArgumentException("start=" + n + " end=" + n2);
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        VcfRecBuilder vcfRecBuilder = new VcfRecBuilder(12 * genotypeValues.nSamples());
        for (int i = n; i < n2; ++i) {
            Marker marker = genotypeValues.marker(i);
            vcfRecBuilder.reset(marker, bl, bl2);
            double[] dArray = new double[marker.nGenotypes()];
            int n3 = genotypeValues.nSamples();
            for (int j = 0; j < n3; ++j) {
                int n4;
                double d = 0.0;
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    dArray[n4] = genotypeValues.value(i, j, n4);
                    d += dArray[n4];
                }
                n4 = 0;
                while (n4 < dArray.length) {
                    int n5 = n4++;
                    dArray[n5] = dArray[n5] / d;
                }
                vcfRecBuilder.addSampleData(dArray);
            }
            vcfRecBuilder.writeRec(printWriter, bl3);
        }
    }

    public static void appendRecords(AlleleProbs alleleProbs, boolean[] blArray, int n, int n2, boolean bl, boolean bl2, PrintWriter printWriter) {
        if (blArray.length != alleleProbs.nMarkers()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        if (n > n2) {
            throw new IllegalArgumentException("start=" + n + " end=" + n2);
        }
        VcfRecBuilder vcfRecBuilder = new VcfRecBuilder(4 * alleleProbs.nSamples());
        for (int i = n; i < n2; ++i) {
            Marker marker = alleleProbs.marker(i);
            vcfRecBuilder.reset(marker, bl, bl2);
            double[] dArray = new double[marker.nAlleles()];
            double[] dArray2 = new double[marker.nAlleles()];
            int n3 = alleleProbs.nSamples();
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < dArray.length; ++k) {
                    dArray[k] = alleleProbs.alProb1(i, j, k);
                    dArray2[k] = alleleProbs.alProb2(i, j, k);
                }
                vcfRecBuilder.addSampleData(dArray, dArray2);
            }
            vcfRecBuilder.writeRec(printWriter, blArray[i]);
        }
    }

    public static void blockedAppendRecords(AlleleProbs alleleProbs, boolean[] blArray, int n, int n2, boolean bl, boolean bl2, PrintWriter printWriter) {
        int n3;
        if (blArray.length != alleleProbs.nMarkers()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        if (n > n2) {
            throw new IllegalArgumentException("start=" + n + " end=" + n2);
        }
        int n4 = alleleProbs.nSamples();
        int n5 = 8;
        int n6 = 4 * alleleProbs.nSamples();
        VcfRecBuilder[] vcfRecBuilderArray = new VcfRecBuilder[n5];
        double[][] dArrayArray = new double[n5][];
        double[][] dArrayArray2 = new double[n5][];
        for (n3 = 0; n3 < vcfRecBuilderArray.length; ++n3) {
            vcfRecBuilderArray[n3] = new VcfRecBuilder(n6);
        }
        for (n3 = n; n3 < n2; n3 += n5) {
            int n7;
            int n8 = Math.min(n2, n3 + n5);
            for (n7 = n3; n7 < n8; ++n7) {
                Marker marker = alleleProbs.marker(n7);
                vcfRecBuilderArray[n7 - n3].reset(marker, bl, bl2);
                dArrayArray[n7 - n3] = new double[marker.nAlleles()];
                dArrayArray2[n7 - n3] = new double[marker.nAlleles()];
                for (int i = 0; i < n4; i += n5) {
                    int n9 = Math.min(i + n5, n4);
                    for (int j = i; j < n9; ++j) {
                        for (int k = 0; k < dArrayArray[n7 - n3].length; ++k) {
                            dArrayArray[n7 - n3][k] = alleleProbs.alProb1(n7, j, k);
                            dArrayArray2[n7 - n3][k] = alleleProbs.alProb2(n7, j, k);
                        }
                        vcfRecBuilderArray[n7 - n3].addSampleData(dArrayArray[n7 - n3], dArrayArray2[n7 - n3]);
                    }
                }
            }
            for (n7 = n3; n7 < n8; ++n7) {
                vcfRecBuilderArray[n7 - n3].writeRec(printWriter, blArray[n7]);
            }
        }
    }

    public static void printFixedFieldsGT(Marker marker, PrintWriter printWriter) {
        printWriter.print(marker);
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print("PASS");
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print("GT");
    }
}

