/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima;

import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.ParametersRange;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFrequencyResponse;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public final class Spectrum {
    private static final double EPS = 1.0E-7;
    private static final double EPS2 = 1.0E-12;
    private static final double TWOPI = Math.PI * 2;
    private final SymmetricFilter num;
    private final SymmetricFilter denom;

    public Spectrum(SymmetricFilter num, SymmetricFilter denom) {
        this.num = num;
        this.denom = denom;
    }

    public double get(double freq) {
        double val = Spectrum.value(this, freq);
        if (Double.isNaN(val)) {
            return Double.POSITIVE_INFINITY;
        }
        return val / (Math.PI * 2);
    }

    static double value(Spectrum s, double x) {
        double d = s.denom.realFrequencyResponse(x);
        double n = s.num.realFrequencyResponse(x);
        if (Math.abs(d) > 1.0E-7) {
            return n / d;
        }
        if (Math.abs(n) < 1.0E-7) {
            try {
                for (int i = 1; i <= 10; ++i) {
                    double dd = new dfr(s.denom, i).evaluate(x);
                    double nd = new dfr(s.num, i).evaluate(x);
                    if (Math.abs(dd) > 1.0E-7) {
                        return nd / dd;
                    }
                    if (!(Math.abs(nd) > 1.0E-7)) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception err) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    public DoubleUnaryOperator asFunction() {
        return f -> this.get(f);
    }

    public SymmetricFilter getDenominator() {
        return this.denom;
    }

    public SymmetricFilter getNumerator() {
        return this.num;
    }

    private static class dfr {
        final int d;
        final SymmetricFilter filter;

        dfr(SymmetricFilter filter, int d) {
            this.filter = filter;
            this.d = d;
        }

        double evaluate(double freq) {
            IntToDoubleFunction weights = this.filter.weights();
            if (this.d % 2 == 0) {
                double s = 0.0;
                for (int i = 1; i < this.filter.length(); ++i) {
                    double c = i;
                    for (int j = 1; j < this.d; ++j) {
                        c *= (double)i;
                    }
                    s += (c *= Math.cos(freq * (double)i) * weights.applyAsDouble(i));
                }
                return s;
            }
            double s = 0.0;
            for (int i = 1; i < this.filter.length(); ++i) {
                double c = i;
                for (int j = 1; j < this.d; ++j) {
                    c *= (double)i;
                }
                s += (c *= Math.sin(freq * (double)i) * weights.applyAsDouble(i));
            }
            return s;
        }
    }

    public static class Minimizer {
        private double m_min;
        private double m_x;
        private static final int MIN_DENOM = 6;

        public double getMinimum() {
            return this.m_min;
        }

        public double getMinimumFrequency() {
            return this.m_x;
        }

        public void minimize(Spectrum spectrum) {
            if (spectrum.denom.length() <= 6) {
                this.minimizeByRoots(spectrum);
            } else {
                this.minimizeByGrid(spectrum);
            }
        }

        public void minimizeByGrid(Spectrum spectrum) {
            if (spectrum.num.length() == 1 && spectrum.denom.length() == 1) {
                this.m_x = 0.0;
                this.m_min = Spectrum.value(spectrum, 0.0);
                return;
            }
            this.m_x = 0.0;
            this.m_min = Double.MAX_VALUE;
            double y = Spectrum.value(spectrum, 0.0);
            if (!Double.isNaN(y)) {
                this.m_min = y;
                this.m_x = 0.0;
            }
            if (!Double.isNaN(y = Spectrum.value(spectrum, Math.PI)) && y < this.m_min) {
                this.m_min = y;
                this.m_x = Math.PI;
            }
            int nd = spectrum.num.getUpperBound() + spectrum.denom.getUpperBound() - 1;
            double step = Math.PI / (double)nd;
            double a = step / 2.0;
            int i = 0;
            while (i < nd) {
                double b = a + step;
                double f = spectrum.denom.realFrequencyResponse(a);
                double na = a;
                while (f <= 0.0 && na < b) {
                    f = spectrum.denom.realFrequencyResponse(na += step / 7.0);
                }
                if (!(na >= b)) {
                    double cmin;
                    SpectrumFunction fn;
                    SpectrumFunctionInstance min;
                    f = spectrum.denom.realFrequencyResponse(b);
                    double nb = b;
                    while (f <= 0.0 && nb > na) {
                        f = spectrum.denom.realFrequencyResponse(nb -= step / 7.0);
                    }
                    if (!(nb <= na) && (min = (fn = new SpectrumFunction(spectrum, na, nb)).min((na + nb) / 2.0)) != null && (cmin = min.f) < this.m_min) {
                        this.m_min = cmin;
                        this.m_x = min.pt;
                    }
                }
                ++i;
                a += step;
            }
        }

        public void minimizeByRoots(Spectrum spectrum) {
            Polynomial r;
            Complex[] roots;
            SymmetricFrequencyResponse fnum = new SymmetricFrequencyResponse(spectrum.num);
            SymmetricFrequencyResponse fdenom = new SymmetricFrequencyResponse(spectrum.denom);
            double scale = fdenom.getIntegral();
            Polynomial num = fnum.getPolynomial().divide(scale);
            Polynomial denom = fdenom.getPolynomial().divide(scale);
            if (num.isZero()) {
                this.m_min = 0.0;
                this.m_x = 0.0;
                return;
            }
            if (num.degree() == 0 && denom.degree() == 0) {
                this.m_min = num.get(0) / denom.get(0);
                this.m_x = 0.0;
                return;
            }
            this.m_x = 0.0;
            this.m_min = Double.MAX_VALUE;
            double y = this.evaluate(num, denom, 0.0);
            if (!Double.isNaN(y)) {
                this.m_min = y;
                this.m_x = 1.5707963267948966;
            }
            if (!Double.isNaN(y = this.evaluate(num, denom, 1.0)) && y < this.m_min) {
                this.m_min = y;
                this.m_x = 0.0;
            }
            if (!Double.isNaN(y = this.evaluate(num, denom, -1.0)) && y < this.m_min) {
                this.m_min = y;
                this.m_x = Math.PI;
            }
            if ((roots = (r = denom.degree() > 0 ? num.derivate().times(denom).minus(num.times(denom.derivate())) : num.derivate()).roots()) != null) {
                for (int i = 0; i < roots.length; ++i) {
                    double x;
                    if (!(Math.abs(roots[i].getIm()) < 1.0E-7) || !((x = roots[i].getRe()) > -1.0) || !(x < 1.0) || Double.isNaN(y = this.evaluate(num, denom, x)) || !(y < this.m_min)) continue;
                    this.m_min = y;
                    this.m_x = Math.acos(x);
                }
            }
        }

        private double evaluate(Polynomial num, Polynomial denom, double x) {
            if (Math.abs(x) < 1.0E-12) {
                x = 0.0;
            }
            double n = num.evaluateAt(x);
            double d = denom.evaluateAt(x);
            if (Math.abs(d) > 1.0E-12) {
                return n / d;
            }
            if (Math.abs(n) > 1.0E-12) {
                return Double.NaN;
            }
            if (x == 0.0) {
                int rmax = Math.min(num.degree(), denom.degree());
                for (int i = 1; i <= rmax; ++i) {
                    boolean sd;
                    double cn = num.get(i);
                    double cd = denom.get(i);
                    boolean sn = Math.abs(cn) > 1.0E-7;
                    boolean bl = sd = Math.abs(cd) > 1.0E-7;
                    if (sn && sd) {
                        return cn / cd;
                    }
                    if (sn) {
                        return Double.NaN;
                    }
                    if (!sd) continue;
                    return 0.0;
                }
                return Double.NaN;
            }
            double[] r = new double[]{1.0, -x};
            Polynomial R = Polynomial.of(r);
            return this.evaluate(num.divide(R), denom.divide(R), x);
        }

        private static class SpectrumFunction
        implements IFunction {
            private final Spectrum spec;
            private final double a;
            private final double b;

            SpectrumFunction(Spectrum spec) {
                this.spec = spec;
                this.a = 0.0;
                this.b = Math.PI;
            }

            SpectrumFunction(Spectrum spec, double a, double b) {
                this.spec = spec;
                this.a = a;
                this.b = b;
            }

            SpectrumFunctionInstance min(double start) {
                double fd = this.spec.denom.realFrequencyResponse(start);
                double z = start;
                if (Math.abs(fd) < 1.0E-7) {
                    do {
                        fd = this.spec.denom.realFrequencyResponse(z += 1.0E-7);
                    } while (z <= this.b && Math.abs(fd) < 1.0E-7);
                    if (z > this.b) {
                        return null;
                    }
                }
                int iter = 0;
                SpectrumFunctionInstance cur = new SpectrumFunctionInstance(this.spec, z);
                double s = cur.f;
                double zcur = z;
                double zprev = z;
                do {
                    zprev = zcur;
                    if (Double.isNaN(zcur -= cur.df / cur.d2f)) break;
                    if (zcur < this.a) {
                        zcur = this.a;
                    } else if (zcur > this.b) {
                        zcur = this.b;
                    }
                    SpectrumFunctionInstance ncur = new SpectrumFunctionInstance(this.spec, zcur);
                    double ns = ncur.f;
                    if (!(ns < s)) continue;
                    cur = ncur;
                    s = ns;
                } while (++iter < 200 && Math.abs(zcur - zprev) > 1.0E-12);
                if (iter == 100) {
                    iter = 0;
                }
                return cur;
            }

            @Override
            public SpectrumFunctionInstance evaluate(DoubleSeq parameters) {
                return new SpectrumFunctionInstance(this.spec, parameters.get(0));
            }

            @Override
            public IParametersDomain getDomain() {
                return new ParametersRange(this.a, this.b, true);
            }
        }

        private static class SpectrumFunctionInstance
        implements IFunctionPoint {
            private final Spectrum spec;
            private final double pt;
            private final double f;
            private final double df;
            private final double d2f;

            SpectrumFunctionInstance(Spectrum spec, double pt) {
                this.spec = spec;
                this.pt = pt;
                fr num = new fr(spec.num);
                fr denom = new fr(spec.denom);
                num.evaluate(pt);
                denom.evaluate(pt);
                double n = num.f;
                double dn = num.df;
                double d2n = num.d2f;
                double d = denom.f;
                double dd = denom.df;
                double d2d = denom.d2f;
                this.f = n / d;
                this.df = (dn * d - n * dd) / (d * d);
                this.d2f = ((d2n * d - n * d2d) * d - 2.0 * (dn * d - n * dd) * dd) / (d * d * d);
            }

            @Override
            public DoubleSeq getParameters() {
                return Doubles.of((double)this.pt);
            }

            @Override
            public double getValue() {
                return Spectrum.value(this.spec, this.pt);
            }

            @Override
            public IFunction getFunction() {
                return new SpectrumFunction(this.spec);
            }
        }
    }

    private static class fr {
        final SymmetricFilter filter;
        private double f;
        private double df;
        private double d2f;

        fr(SymmetricFilter filter) {
            this.filter = filter;
        }

        void evaluate(double freq) {
            DoubleSeq weights = this.filter.coefficientsAsPolynomial().coefficients();
            DoubleSeqCursor cursor = weights.cursor();
            this.f = cursor.getAndNext();
            this.df = 0.0;
            double c1 = Math.cos(freq);
            double s1 = Math.sin(freq);
            double c0 = c1;
            double s0 = s1;
            for (int i = 1; i < weights.length(); ++i) {
                double w = cursor.getAndNext();
                double wc = 2.0 * c0 * w;
                double ws = 2.0 * s0 * w;
                double cnext = c0 * c1 - s0 * s1;
                double snext = s0 * c1 + c0 * s1;
                c0 = cnext;
                s0 = snext;
                this.f += wc;
                this.df -= (double)i * ws;
                this.d2f -= (double)(i * i) * wc;
            }
        }

        double f() {
            return this.f;
        }

        double df() {
            return this.df;
        }

        double d2f() {
            return this.d2f;
        }
    }
}

