/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import standalone_spreadsheet.org.dhatim.fastexcel.CachedString;
import standalone_spreadsheet.org.dhatim.fastexcel.Writer;

class StringCache {
    private long count;
    private final HashMap<String, CachedString> strings = new HashMap();

    StringCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedString cacheString(String s) {
        CachedString result;
        HashMap<String, CachedString> hashMap = this.strings;
        synchronized (hashMap) {
            ++this.count;
            result = this.strings.get(s);
            if (result == null) {
                result = new CachedString(s, this.strings.size());
                this.strings.put(s, result);
            }
        }
        return result;
    }

    void write(Writer w) throws IOException {
        w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><sst xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" count=\"").append(this.count).append("\" uniqueCount=\"").append(this.strings.size()).append("\">");
        Stream<String> sortedStrings = this.strings.entrySet().stream().sorted(Comparator.comparingInt(e -> ((CachedString)e.getValue()).getIndex())).map(Map.Entry::getKey);
        Iterator it = sortedStrings.iterator();
        while (it.hasNext()) {
            w.append("<si><t xml:space=\"preserve\">").appendEscaped((String)it.next()).append("</t></si>");
        }
        w.append("</sst>");
    }
}

