## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)

## ----libname------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
sdtmdata <- repfun::ru_libname(datdir)

## ----retrieve-----------------------------------------------------------------
sdtm.ae <- sdtmdata$ae.rda() 

## ----addtimes-----------------------------------------------------------------
sdtm.ae %>% mutate(AEDTC=ifelse(nchar(AEDTC)==10,paste0(AEDTC,'T12:30:50'),AEDTC),
                   AESTDTC=ifelse(nchar(AESTDTC)==10,paste0(AESTDTC,'T00:00:01'),AESTDTC),
                   AEENDTC=ifelse(nchar(AEENDTC)==10,paste0(AEENDTC,'T00:00:02'),AEENDTC)) -> sdtm.ae2

## ----convert------------------------------------------------------------------
sdtm.ae3 <- repfun::ru_datetime(sdtm.ae2)

## ----showresult---------------------------------------------------------------
knitr::kable(head(sdtm.ae3[,grepl('(DT$|TM$|DTC$)',names(sdtm.ae3))],10), 
             caption = "SDTM.AE with Character Dates/Times Converted")

