/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.real;

import java.util.Arrays;
import java.util.OptionalDouble;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.RealEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.VariableUtils;

public class PropScalarMixed
extends Propagator<Variable> {
    protected final int l;
    protected final double b;
    protected final double[] I;
    protected double maxI;
    protected double sumLB;
    protected double sumUB;
    protected final Operator o;
    private final double[] c;
    private final double sprc;

    public PropScalarMixed(Variable[] variables, double[] coeffs, Operator o, double b) {
        super(variables, (Priority)PropagatorPriority.LINEAR, false);
        this.c = coeffs;
        this.l = variables.length;
        OptionalDouble d = Arrays.stream(this.vars).filter(VariableUtils::isReal).mapToDouble(r -> r.asRealVar().getPrecision()).min();
        this.sprc = d.isPresent() ? d.getAsDouble() : variables[0].getModel().getPrecision();
        this.o = o;
        this.b = b;
        this.I = new double[this.l];
        this.maxI = 0.0;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        switch (this.o) {
            case LE: {
                if (VariableUtils.isReal(this.vars[vIdx])) {
                    return this.c[vIdx] > 0.0 ? RealEventType.INCLOW.getMask() : RealEventType.DECUPP.getMask();
                }
                return IntEventType.combine(IntEventType.INSTANTIATE, this.c[vIdx] > 0.0 ? IntEventType.INCLOW : IntEventType.DECUPP);
            }
            case GE: {
                if (VariableUtils.isReal(this.vars[vIdx])) {
                    return this.c[vIdx] > 0.0 ? RealEventType.DECUPP.getMask() : RealEventType.INCLOW.getMask();
                }
                return IntEventType.combine(IntEventType.INSTANTIATE, this.c[vIdx] > 0.0 ? IntEventType.DECUPP : IntEventType.INCLOW);
            }
        }
        if (VariableUtils.isReal(this.vars[vIdx])) {
            return RealEventType.BOUND.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    protected void filter() throws ContradictionException {
        this.prepare();
        switch (this.o) {
            case LE: {
                this.filterOnLeq();
                break;
            }
            case GE: {
                this.filterOnGeq();
                break;
            }
            default: {
                this.filterOnEq();
            }
        }
    }

    protected void prepare() {
        this.sumUB = 0.0;
        this.sumLB = 0.0;
        this.maxI = 0.0;
        for (int i = 0; i < this.l; ++i) {
            double ub;
            double lb;
            if (VariableUtils.isReal(this.vars[i])) {
                if (this.c[i] > 0.0) {
                    lb = this.vars[i].asRealVar().getLB() * this.c[i];
                    ub = this.vars[i].asRealVar().getUB() * this.c[i];
                } else {
                    lb = this.vars[i].asRealVar().getUB() * this.c[i];
                    ub = this.vars[i].asRealVar().getLB() * this.c[i];
                }
            } else if (this.c[i] > 0.0) {
                lb = (double)this.vars[i].asIntVar().getLB() * this.c[i];
                ub = (double)this.vars[i].asIntVar().getUB() * this.c[i];
            } else {
                lb = (double)this.vars[i].asIntVar().getUB() * this.c[i];
                ub = (double)this.vars[i].asIntVar().getLB() * this.c[i];
            }
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (!(this.maxI < this.I[i])) continue;
            this.maxI = this.I[i];
        }
    }

    protected void filterOnEq() throws ContradictionException {
        boolean anychange;
        double F2 = this.b - this.sumLB;
        double E = this.sumUB - this.b;
        do {
            anychange = false;
            if (F2 < 0.0 || E < 0.0) {
                this.fails();
            }
            if (this.maxI - F2 > this.sprc || this.maxI - E > this.sprc) {
                this.maxI = 0.0;
                for (int i = 0; i < this.l; ++i) {
                    double ub;
                    double lb;
                    if (this.I[i] - F2 > 0.0) {
                        double nub;
                        if (this.c[i] > 0.0) {
                            if (VariableUtils.isReal(this.vars[i])) {
                                lb = this.vars[i].asRealVar().getLB() * this.c[i];
                                ub = lb + this.I[i];
                                if (this.vars[i].asRealVar().updateUpperBound((F2 + lb) / this.c[i], this)) {
                                    nub = this.vars[i].asRealVar().getUB() * this.c[i];
                                    E += nub - ub;
                                    this.I[i] = nub - lb;
                                    anychange = true;
                                }
                            } else {
                                lb = (double)this.vars[i].asIntVar().getLB() * this.c[i];
                                ub = lb + this.I[i];
                                if (this.vars[i].asIntVar().updateUpperBound(this.divFloor(F2 + lb, this.c[i]), (ICause)this)) {
                                    nub = (double)this.vars[i].asIntVar().getUB() * this.c[i];
                                    E += nub - ub;
                                    this.I[i] = nub - lb;
                                    anychange = true;
                                }
                            }
                        } else if (VariableUtils.isReal(this.vars[i])) {
                            lb = this.vars[i].asRealVar().getUB() * this.c[i];
                            ub = lb + this.I[i];
                            if (this.vars[i].asRealVar().updateLowerBound((-F2 - lb) / -this.c[i], this)) {
                                nub = this.vars[i].asRealVar().getLB() * this.c[i];
                                E += nub - ub;
                                this.I[i] = nub - lb;
                                anychange = true;
                            }
                        } else {
                            lb = (double)this.vars[i].asIntVar().getUB() * this.c[i];
                            ub = lb + this.I[i];
                            if (this.vars[i].asIntVar().updateLowerBound(this.divCeil(-F2 - lb, -this.c[i]), (ICause)this)) {
                                nub = (double)this.vars[i].asIntVar().getLB() * this.c[i];
                                E += nub - ub;
                                this.I[i] = nub - lb;
                                anychange = true;
                            }
                        }
                    }
                    if (this.I[i] - E > 0.0) {
                        double nlb;
                        if (this.c[i] > 0.0) {
                            if (VariableUtils.isReal(this.vars[i])) {
                                ub = this.vars[i].asRealVar().getUB() * this.c[i];
                                lb = ub - this.I[i];
                                if (this.vars[i].asRealVar().updateLowerBound((ub - E) / this.c[i], this)) {
                                    nlb = this.vars[i].asRealVar().getLB() * this.c[i];
                                    F2 -= nlb - lb;
                                    this.I[i] = ub - nlb;
                                    anychange = true;
                                }
                            } else {
                                ub = (double)this.vars[i].asIntVar().getUB() * this.c[i];
                                lb = ub - this.I[i];
                                if (this.vars[i].asIntVar().updateLowerBound(this.divCeil(ub - E, this.c[i]), (ICause)this)) {
                                    nlb = (double)this.vars[i].asIntVar().getLB() * this.c[i];
                                    F2 -= nlb - lb;
                                    this.I[i] = ub - nlb;
                                    anychange = true;
                                }
                            }
                        } else if (VariableUtils.isReal(this.vars[i])) {
                            ub = this.vars[i].asRealVar().getLB() * this.c[i];
                            lb = ub - this.I[i];
                            if (this.vars[i].asRealVar().updateUpperBound((-ub + E) / -this.c[i], this)) {
                                nlb = this.vars[i].asRealVar().getUB() * this.c[i];
                                F2 -= nlb - lb;
                                this.I[i] = ub - nlb;
                                anychange = true;
                            }
                        } else {
                            ub = (double)this.vars[i].asIntVar().getLB() * this.c[i];
                            lb = ub - this.I[i];
                            if (this.vars[i].asIntVar().updateUpperBound(this.divFloor(-ub + E, -this.c[i]), (ICause)this)) {
                                nlb = (double)this.vars[i].asIntVar().getUB() * this.c[i];
                                F2 -= nlb - lb;
                                this.I[i] = ub - nlb;
                                anychange = true;
                            }
                        }
                    }
                    if (!(this.maxI < this.I[i])) continue;
                    this.maxI = this.I[i];
                }
            }
            if (!(F2 < 0.0) || !(E < 0.0)) continue;
            this.setPassive();
            return;
        } while (anychange);
    }

    protected void filterOnLeq() throws ContradictionException {
        double F2 = this.b - this.sumLB;
        double E = this.sumUB - this.b;
        if (F2 < 0.0) {
            this.fails();
        }
        if (this.maxI - F2 > this.sprc) {
            this.maxI = 0.0;
            for (int i = 0; i < this.l; ++i) {
                if (this.I[i] - F2 > 0.0) {
                    double nub;
                    double ub;
                    double lb;
                    if (this.c[i] > 0.0) {
                        if (VariableUtils.isReal(this.vars[i])) {
                            lb = this.vars[i].asRealVar().getLB() * this.c[i];
                            ub = lb + this.I[i];
                            if (this.vars[i].asRealVar().updateUpperBound((F2 + lb) / this.c[i], this)) {
                                nub = this.vars[i].asRealVar().getUB() * this.c[i];
                                E += nub - ub;
                                this.I[i] = nub - lb;
                            }
                        } else {
                            lb = (double)this.vars[i].asIntVar().getLB() * this.c[i];
                            ub = lb + this.I[i];
                            if (this.vars[i].asIntVar().updateUpperBound(this.divFloor(F2 + lb, this.c[i]), (ICause)this)) {
                                nub = (double)this.vars[i].asIntVar().getUB() * this.c[i];
                                E += nub - ub;
                                this.I[i] = nub - lb;
                            }
                        }
                    } else if (VariableUtils.isReal(this.vars[i])) {
                        lb = this.vars[i].asRealVar().getUB() * this.c[i];
                        ub = lb + this.I[i];
                        if (this.vars[i].asRealVar().updateLowerBound((-F2 - lb) / -this.c[i], this)) {
                            nub = this.vars[i].asRealVar().getLB() * this.c[i];
                            E += nub - ub;
                            this.I[i] = nub - lb;
                        }
                    } else {
                        lb = (double)this.vars[i].asIntVar().getUB() * this.c[i];
                        ub = lb + this.I[i];
                        if (this.vars[i].asIntVar().updateLowerBound(this.divCeil(-F2 - lb, -this.c[i]), (ICause)this)) {
                            nub = (double)this.vars[i].asIntVar().getLB() * this.c[i];
                            E += nub - ub;
                            this.I[i] = nub - lb;
                        }
                    }
                }
                if (!(this.maxI < this.I[i])) continue;
                this.maxI = this.I[i];
            }
        }
        if (E < 0.0) {
            this.setPassive();
        }
    }

    protected void filterOnGeq() throws ContradictionException {
        double F2 = this.b - this.sumLB;
        double E = this.sumUB - this.b;
        if (E < 0.0) {
            this.fails();
        }
        if (this.maxI - E > this.sprc) {
            this.maxI = 0.0;
            for (int i = 0; i < this.l; ++i) {
                if (this.I[i] - E > 0.0) {
                    double nlb;
                    double lb;
                    double ub;
                    if (this.c[i] > 0.0) {
                        if (VariableUtils.isReal(this.vars[i])) {
                            ub = this.vars[i].asRealVar().getUB() * this.c[i];
                            lb = ub - this.I[i];
                            if (this.vars[i].asRealVar().updateLowerBound((ub - E) / this.c[i], this)) {
                                nlb = this.vars[i].asRealVar().getLB() * this.c[i];
                                F2 -= nlb - lb;
                                this.I[i] = ub - nlb;
                            }
                        } else {
                            ub = (double)this.vars[i].asIntVar().getUB() * this.c[i];
                            lb = ub - this.I[i];
                            if (this.vars[i].asIntVar().updateLowerBound(this.divCeil(ub - E, this.c[i]), (ICause)this)) {
                                nlb = (double)this.vars[i].asIntVar().getLB() * this.c[i];
                                F2 -= nlb - lb;
                                this.I[i] = ub - nlb;
                            }
                        }
                    } else if (VariableUtils.isReal(this.vars[i])) {
                        ub = this.vars[i].asRealVar().getLB() * this.c[i];
                        lb = ub - this.I[i];
                        if (this.vars[i].asRealVar().updateUpperBound((-ub + E) / -this.c[i], this)) {
                            nlb = this.vars[i].asRealVar().getUB() * this.c[i];
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                        }
                    } else {
                        ub = (double)this.vars[i].asIntVar().getLB() * this.c[i];
                        lb = ub - this.I[i];
                        if (this.vars[i].asIntVar().updateUpperBound(this.divFloor(-ub + E, -this.c[i]), (ICause)this)) {
                            nlb = (double)this.vars[i].asIntVar().getUB() * this.c[i];
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                        }
                    }
                }
                if (!(this.maxI < this.I[i])) continue;
                this.maxI = this.I[i];
            }
        }
        if (F2 < 0.0) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        double sumUB = 0.0;
        double sumLB = 0.0;
        for (int i = 0; i < this.l; ++i) {
            if (VariableUtils.isReal(this.vars[i])) {
                if (this.c[i] > 0.0) {
                    sumLB += this.vars[i].asRealVar().getLB() * this.c[i];
                    sumUB += this.vars[i].asRealVar().getUB() * this.c[i];
                    continue;
                }
                sumLB += this.vars[i].asRealVar().getUB() * this.c[i];
                sumUB += this.vars[i].asRealVar().getLB() * this.c[i];
                continue;
            }
            if (this.c[i] > 0.0) {
                sumLB += (double)this.vars[i].asIntVar().getLB() * this.c[i];
                sumUB += (double)this.vars[i].asIntVar().getUB() * this.c[i];
                continue;
            }
            sumLB += (double)this.vars[i].asIntVar().getUB() * this.c[i];
            sumUB += (double)this.vars[i].asIntVar().getLB() * this.c[i];
        }
        return this.check(sumLB, sumUB);
    }

    protected ESat check(double sumLB, double sumUB) {
        switch (this.o) {
            case LE: {
                if (sumLB <= this.b) {
                    return ESat.TRUE;
                }
                if (sumLB > this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            case GE: {
                if (sumUB >= this.b) {
                    return ESat.TRUE;
                }
                if (sumUB < this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
        }
        if (sumLB <= this.b && this.b <= sumUB) {
            return ESat.TRUE;
        }
        if (sumUB < this.b || sumLB > this.b) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(this.c[0]).append('.').append(this.vars[0].getName());
        for (int i = 1; i < this.l; ++i) {
            if (this.c[i] > 0.0) {
                linComb.append(" + ").append(this.c[i]);
            } else {
                linComb.append(" - ").append(-this.c[i]);
            }
            linComb.append('.').append(this.vars[i].getName());
        }
        linComb.append(" ").append((Object)this.o).append(" ");
        linComb.append(this.b);
        return linComb.toString();
    }

    private int divFloor(double a2, double b) {
        if (a2 >= 0.0) {
            return (int)(a2 / b);
        }
        return (int)((a2 - b + 1.0) / b);
    }

    private int divCeil(double a2, double b) {
        if (a2 >= 0.0) {
            return (int)((a2 + b - 1.0) / b);
        }
        return (int)(a2 / b);
    }
}

