/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.measure;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.chocosolver.solver.objective.IBoundsManager;
import org.chocosolver.solver.search.SearchState;
import org.chocosolver.solver.search.measure.Measures;

public final class MeasuresRecorder
extends Measures {
    private static final long serialVersionUID = -2027525308178413040L;
    private long startingTime;
    private transient LongSupplier currentNanoTime = () -> this.timeCount;

    public MeasuresRecorder(String modelName) {
        super(modelName);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getTimeCountInNanoSeconds();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.currentNanoTime = () -> this.timeCount;
    }

    @Override
    public long getTimeCountInNanoSeconds() {
        this.timeCount = this.currentNanoTime.getAsLong();
        return super.getTimeCountInNanoSeconds();
    }

    public void updateTimeToBestSolution() {
        this.timeToBestSolution = this.currentNanoTime.getAsLong();
    }

    public void startStopwatch() {
        this.startingTime = System.nanoTime();
        this.currentNanoTime = () -> System.nanoTime() - this.startingTime;
    }

    public void stopStopwatch() {
        this.timeCount = this.currentNanoTime.getAsLong();
        this.currentNanoTime = () -> this.timeCount;
    }

    public void setModelName(String name) {
        this.modelName = name;
    }

    public void setObjectiveOptimal(boolean objectiveOptimal) {
        this.objectiveOptimal = objectiveOptimal;
    }

    public void reset() {
        this.state = SearchState.NEW;
        this.objectiveOptimal = false;
        this.solutionCount = 0L;
        this.stopStopwatch();
        this.timeCount = 0L;
        this.nodeCount = 0L;
        this.backtrackCount = 0L;
        this.failCount = 0L;
        this.restartCount = 0L;
        this.depth = 0L;
        this.maxDepth = 0L;
        this.propagationCount = 0L;
    }

    public void incNodeCount() {
        ++this.nodeCount;
        ++this.depth;
        this.maxDepth = Math.max(this.maxDepth, this.depth);
    }

    public void incBackTrackCount() {
        --this.depth;
        ++this.backtrackCount;
    }

    public void incBackjumpCount() {
        ++this.backjumpCount;
    }

    public void incFailCount() {
        ++this.failCount;
    }

    public void incFixpointCount() {
        ++this.fixpointCount;
    }

    public void incPropagationCount() {
        ++this.propagationCount;
    }

    public void incRestartCount() {
        ++this.restartCount;
    }

    public void incSolutionCount() {
        ++this.solutionCount;
    }

    public void setSearchState(SearchState state) {
        Objects.requireNonNull(state);
        this.state = state;
    }

    public void setBoundsManager(IBoundsManager boundsManager) {
        Objects.requireNonNull(boundsManager);
        this.boundsManager = boundsManager;
    }

    public void setReadingTimeCount(long readingTimeCount) {
        if (this.readingTimeCount <= 0L) {
            this.readingTimeCount = readingTimeCount;
        }
    }
}

