/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import java.util.Arrays;
import org.chocosolver.memory.trailing.StoredBool;
import org.chocosolver.memory.trailing.trail.chunck.World;

public class BoolWorld
implements World {
    private StoredBool[] variableStack;
    private boolean[] valueStack;
    private int[] stampStack;
    private int now = 0;
    private final int defaultSize;
    private final double loadfactor;

    public BoolWorld(int defaultSize, double loadfactor) {
        this.loadfactor = loadfactor;
        this.defaultSize = defaultSize;
    }

    public void savePreviousState(StoredBool v, boolean oldValue, int oldStamp) {
        if (this.stampStack == null) {
            this.valueStack = new boolean[this.defaultSize];
            this.stampStack = new int[this.defaultSize];
            this.variableStack = new StoredBool[this.defaultSize];
        }
        this.valueStack[this.now] = oldValue;
        this.variableStack[this.now] = v;
        this.stampStack[this.now] = oldStamp;
        ++this.now;
        if (this.now == this.valueStack.length) {
            int newCapacity = (int)((double)this.variableStack.length * this.loadfactor);
            this.valueStack = Arrays.copyOf(this.valueStack, newCapacity);
            this.variableStack = Arrays.copyOf(this.variableStack, newCapacity);
            this.stampStack = Arrays.copyOf(this.stampStack, newCapacity);
        }
    }

    @Override
    public void revert() {
        for (int i = this.now - 1; i >= 0; --i) {
            this.variableStack[i]._set(this.valueStack[i], this.stampStack[i]);
        }
    }

    @Override
    public void clear() {
        this.now = 0;
    }

    @Override
    public int used() {
        return this.now;
    }

    @Override
    public int allocated() {
        return this.stampStack == null ? 0 : this.stampStack.length;
    }
}

