/*
 * Decompiled with CFR 0.152.
 */
package io.github.crew102.rapidrake.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class Result {
    private String[] fullKeywords;
    private String[] stemmedKeywords;
    private float[] scores;

    public Result(String[] fullKeywords, String[] stemmedKeywords, float[] scores) {
        this.fullKeywords = fullKeywords;
        this.stemmedKeywords = stemmedKeywords;
        this.scores = scores;
    }

    public String[] getFullKeywords() {
        return this.fullKeywords;
    }

    public String[] getStemmedKeywords() {
        return this.stemmedKeywords;
    }

    public float[] getScores() {
        return this.scores;
    }

    public String toString() {
        DecimalFormat dFormat = new DecimalFormat("###.##");
        Object[] keyScore = new String[this.fullKeywords.length];
        for (int i = 0; i < this.fullKeywords.length; ++i) {
            keyScore[i] = this.fullKeywords[i] + " (" + dFormat.format(this.scores[i]) + ")";
        }
        return Arrays.toString(keyScore);
    }

    public Result distinct() {
        ArrayList<String> fullKeywordsListOut = new ArrayList<String>();
        ArrayList<String> stemmedKeyListOut = new ArrayList<String>();
        ArrayList<Float> scoresListOut = new ArrayList<Float>();
        for (int i = 0; i < this.fullKeywords.length; ++i) {
            String oneKey = this.fullKeywords[i];
            if (fullKeywordsListOut.contains(oneKey)) continue;
            fullKeywordsListOut.add(oneKey);
            stemmedKeyListOut.add(this.stemmedKeywords[i]);
            scoresListOut.add(Float.valueOf(this.scores[i]));
        }
        this.fullKeywords = fullKeywordsListOut.toArray(new String[fullKeywordsListOut.size()]);
        this.stemmedKeywords = stemmedKeyListOut.toArray(new String[stemmedKeyListOut.size()]);
        float[] scores = new float[scoresListOut.size()];
        for (int i = 0; i < scores.length; ++i) {
            scores[i] = ((Float)scoresListOut.get(i)).floatValue();
        }
        this.scores = scores;
        return this;
    }
}

