library(shinytest2)
app <- AppDriver$new(
  "../../", view = interactive(),
  options = list(display.mode = "normal")
)

test_that("Plotly input values in Shiny", {
  app$expect_values()
  app$set_inputs(`plotly_hover-A` = "[{\"curveNumber\":0,\"pointNumber\":7,\"x\":24.4,\"y\":3.19,\"customdata\":\"Merc 240D\"}]", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_click-A` = "[{\"curveNumber\":0,\"pointNumber\":7,\"x\":24.4,\"y\":3.19,\"customdata\":\"Merc 240D\"}]", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_hover-A` = character(0), allow_no_input_binding_ = TRUE)
  Sys.sleep(1)
  app$expect_values()
  app$set_inputs(`plotly_brushing-A` = "{\"x\":[25.726819184123485,25.98332414553473],\"y\":[1.3174499999999998,5.61955]}", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_selecting-A` = "[]", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_brushing-A` = "{\"x\":[24.64379823594267,25.98332414553473],\"y\":[3.2093373493975905,3.5073743975903615]}", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_brushing-A` = "{\"x\":[24.045286659316428,25.98332414553473],\"y\":[3.040881626506024,3.5073743975903615]}", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_selecting-A` = "[{\"curveNumber\":0,\"pointNumber\":7,\"x\":24.4,\"y\":3.19,\"customdata\":\"Merc 240D\"}]", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_brushing-A` = "{\"x\":[23.95978500551268,25.98332414553473],\"y\":[3.0020072289156627,3.5073743975903615]}", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_selected-A` = "[{\"curveNumber\":0,\"pointNumber\":7,\"x\":24.4,\"y\":3.19,\"customdata\":\"Merc 240D\"}]", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_brushed-A` = "{\"x\":[23.95978500551268,25.98332414553473],\"y\":[3.0020072289156627,3.5073743975903615]}", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_hover-A` = "[{\"curveNumber\":0,\"pointNumber\":7,\"x\":24.4,\"y\":3.19,\"customdata\":\"Merc 240D\"}]", allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_hover-A` = character(0), allow_no_input_binding_ = TRUE)
  app$expect_values()
  app$set_inputs(`plotly_selected-A` = character(0), allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_brushed-A` = character(0), allow_no_input_binding_ = TRUE)
  #app$set_inputs(`plotly_selected-A` = character(0), allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_selecting-A` = character(0), allow_no_input_binding_ = TRUE)
  #app$set_inputs(`plotly_brushed-A` = character(0), allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_brushing-A` = character(0), allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_click-A` = character(0), allow_no_input_binding_ = TRUE)
  app$set_inputs(`plotly_deselect-A` = "\"plot\"", allow_no_input_binding_ = TRUE)
  app$expect_values()
})
